/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.cdi.AopHelper;
import org.apache.shiro.cdi.ShiroSecureAnnotation;

@Interceptor
@ShiroSecureAnnotation
@Dependent
@Priority(value=1000)
public class ShiroSecurityInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;

    @AroundInvoke
    public Object propagateShiroSecurity(InvocationContext ctx) throws Exception {
        this.checkPermissions(ctx);
        return ctx.proceed();
    }

    private void checkPermissions(InvocationContext ctx) throws Exception {
        List<AopHelper.SecurityInterceptor> siList = AopHelper.createSecurityInterceptors(ctx.getMethod(), ctx.getMethod().getDeclaringClass());
        siList.forEach(AopHelper.SecurityInterceptor::intercept);
    }
}

