/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cdi;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.cdi.annotations.NoSessionCreation;
import org.apache.shiro.cdi.annotations.Principal;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ShiroComponentProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroComponentProducer.class);

    @Produces
    public static SecurityManager getSecurityManager() {
        return SecurityUtils.getSecurityManager();
    }

    @Produces
    @RequestScoped
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    @Produces
    @RequestScoped
    public static Session getSession() {
        return SecurityUtils.getSubject().getSession();
    }

    @Produces
    @NoSessionCreation
    @RequestScoped
    public static Session getSessionNoCreation() {
        return Optional.ofNullable(SecurityUtils.getSubject().getSession(false)).orElseThrow(InvalidSessionException::new);
    }

    @Produces
    @Principal
    public static <T> Supplier<T> getPrincipal(InjectionPoint injectionPoint) {
        ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
        Class principalType = (Class)parameterizedType.getActualTypeArguments()[0];
        SerializableSupplier supplier = () -> SecurityUtils.getSubject().getPrincipals().oneByType(principalType);
        return supplier;
    }

    static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }
}

