/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cdi;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class AnnotatedTypeWrapper<T>
implements AnnotatedType<T> {
    private final AnnotatedType<T> wrapped;
    private final Set<Annotation> annotations;

    public AnnotatedTypeWrapper(AnnotatedType<T> wrapped, Annotation ... additionalAnnotations) {
        this(wrapped, true, Set.of(additionalAnnotations), Set.of());
    }

    public AnnotatedTypeWrapper(AnnotatedType<T> wrapped, boolean keepOriginalAnnotations, Set<Annotation> additionalAnnotations, Set<Annotation> annotationsToRemove) {
        this.wrapped = wrapped;
        Stream.Builder builder = Stream.builder();
        if (keepOriginalAnnotations) {
            Set annotationTypesToExclude = annotationsToRemove.stream().map(AnnotatedTypeWrapper::checkIfAnnotation).map(Annotation::annotationType).collect(Collectors.toSet());
            wrapped.getAnnotations().stream().filter(ann -> !annotationTypesToExclude.contains(ann.annotationType())).forEach(builder::add);
        }
        additionalAnnotations.forEach(annotation -> this.addToBuilder(builder, (Annotation)annotation));
        this.annotations = builder.build().collect(Collectors.toSet());
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.stream().anyMatch(annotationType::isInstance);
    }

    private void addToBuilder(Stream.Builder<Annotation> builder, Annotation ann) {
        AnnotatedTypeWrapper.checkIfAnnotation(ann);
        builder.add(ann);
    }

    private static Annotation checkIfAnnotation(Annotation ann) {
        if (!ann.annotationType().isInstance(ann)) {
            throw new IllegalArgumentException(ann.getClass().getName());
        }
        return ann;
    }

    @Generated
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public Class<T> getJavaClass() {
        return this.wrapped.getJavaClass();
    }

    @Generated
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.wrapped.getConstructors();
    }

    @Generated
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.wrapped.getMethods();
    }

    @Generated
    public Set<AnnotatedField<? super T>> getFields() {
        return this.wrapped.getFields();
    }

    @Generated
    public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
        return this.wrapped.getAnnotations(annotationType);
    }

    @Generated
    public Type getBaseType() {
        return this.wrapped.getBaseType();
    }

    @Generated
    public Set<Type> getTypeClosure() {
        return this.wrapped.getTypeClosure();
    }

    @Generated
    public <T extends Annotation> T getAnnotation(Class<T> arg0) {
        return (T)this.wrapped.getAnnotation(arg0);
    }

    private abstract class AT
    implements AnnotatedType<T> {
        private AT() {
        }
    }
}

