/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.servlet.ShiroHttpSession;

public class HttpServletSession
implements Session {
    private static final String HOST_SESSION_KEY = HttpServletSession.class.getName() + ".HOST_SESSION_KEY";
    private static final String TOUCH_OBJECT_SESSION_KEY = HttpServletSession.class.getName() + ".TOUCH_OBJECT_SESSION_KEY";
    private HttpSession httpSession = null;

    public HttpServletSession(HttpSession httpSession, String host) {
        if (httpSession == null) {
            String msg = "HttpSession constructor argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (httpSession instanceof ShiroHttpSession) {
            String msg = "HttpSession constructor argument cannot be an instance of ShiroHttpSession.  This is enforced to prevent circular dependencies and infinite loops.";
            throw new IllegalArgumentException(msg);
        }
        this.httpSession = httpSession;
        if (StringUtils.hasText(host)) {
            this.setHost(host);
        }
    }

    @Override
    public Serializable getId() {
        return this.httpSession.getId();
    }

    @Override
    public Date getStartTimestamp() {
        return new Date(this.httpSession.getCreationTime());
    }

    @Override
    public Date getLastAccessTime() {
        return new Date(this.httpSession.getLastAccessedTime());
    }

    @Override
    public long getTimeout() throws InvalidSessionException {
        try {
            return this.httpSession.getMaxInactiveInterval() * 1000;
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
        try {
            int timeout = Long.valueOf(maxIdleTimeInMillis / 1000L).intValue();
            this.httpSession.setMaxInactiveInterval(timeout);
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    protected void setHost(String host) {
        this.setAttribute(HOST_SESSION_KEY, host);
    }

    @Override
    public String getHost() {
        return (String)this.getAttribute(HOST_SESSION_KEY);
    }

    @Override
    public void touch() throws InvalidSessionException {
        try {
            this.httpSession.setAttribute(TOUCH_OBJECT_SESSION_KEY, (Object)TOUCH_OBJECT_SESSION_KEY);
            this.httpSession.removeAttribute(TOUCH_OBJECT_SESSION_KEY);
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public void stop() throws InvalidSessionException {
        try {
            this.httpSession.invalidate();
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        try {
            Enumeration namesEnum = this.httpSession.getAttributeNames();
            ArrayList keys = null;
            if (namesEnum != null) {
                keys = new ArrayList();
                while (namesEnum.hasMoreElements()) {
                    keys.add(namesEnum.nextElement());
                }
            }
            return keys;
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    private static String assertString(Object key) {
        if (!(key instanceof String)) {
            String msg = "HttpSession based implementations of the Shiro Session interface requires attribute keys to be String objects.  The HttpSession class does not support anything other than String keys.";
            throw new IllegalArgumentException(msg);
        }
        return (String)key;
    }

    @Override
    public Object getAttribute(Object key) throws InvalidSessionException {
        try {
            return this.httpSession.getAttribute(HttpServletSession.assertString(key));
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        try {
            this.httpSession.setAttribute(HttpServletSession.assertString(key), value);
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public Object removeAttribute(Object key) throws InvalidSessionException {
        try {
            String sKey = HttpServletSession.assertString(key);
            Object removed = this.httpSession.getAttribute(sKey);
            this.httpSession.removeAttribute(sKey);
            return removed;
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }
}

