/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.support.hashes.bcrypt;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashSpi;
import org.apache.shiro.crypto.support.hashes.bcrypt.BCryptHash;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.SimpleByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCryptProvider
implements HashSpi {
    private static final Logger LOG = LoggerFactory.getLogger(BCryptProvider.class);

    public Set<String> getImplementedAlgorithms() {
        return BCryptHash.getAlgorithmsBcrypt();
    }

    public BCryptHash fromString(String format) {
        return BCryptHash.fromString(format);
    }

    public HashSpi.HashFactory newHashFactory(Random random) {
        return new BCryptHashFactory(random);
    }

    static class BCryptHashFactory
    implements HashSpi.HashFactory {
        private final SecureRandom random;

        public BCryptHashFactory(Random random) {
            if (!(random instanceof SecureRandom)) {
                throw new IllegalArgumentException("Only SecureRandom instances are supported at the moment!");
            }
            this.random = (SecureRandom)random;
        }

        public BCryptHash generate(HashRequest hashRequest) {
            String algorithmName = hashRequest.getAlgorithmName().orElse("2y");
            ByteSource salt = this.getSalt(hashRequest);
            int cost = this.getCost(hashRequest);
            return BCryptHash.generate(algorithmName, hashRequest.getSource(), salt, cost);
        }

        private int getCost(HashRequest hashRequest) {
            Map parameters = hashRequest.getParameters();
            Optional<String> optCostStr = Optional.ofNullable(parameters.get("BCrypt.cost")).map(obj -> (String)obj);
            if (!optCostStr.isPresent()) {
                return 10;
            }
            String costStr = optCostStr.orElseThrow(NoSuchElementException::new);
            try {
                int cost = Integer.parseInt(costStr, 10);
                BCryptHash.checkValidCost(cost);
                return cost;
            }
            catch (IllegalArgumentException costEx) {
                String message = String.format(Locale.ENGLISH, "Expected Integer for parameter %s, but %s is not parsable or valid.", "BCrypt.cost", costStr);
                LOG.warn(message, (Throwable)costEx);
                return 10;
            }
        }

        private ByteSource getSalt(HashRequest hashRequest) {
            Map parameters = hashRequest.getParameters();
            Optional<String> optSaltBase64 = Optional.ofNullable(parameters.get("BCrypt.salt")).map(obj -> (String)obj);
            if (!optSaltBase64.isPresent()) {
                return BCryptHash.createSalt(this.random);
            }
            String saltBase64 = optSaltBase64.orElseThrow(NoSuchElementException::new);
            byte[] saltBytes = Base64.getDecoder().decode(saltBase64);
            if (saltBytes.length != 16) {
                return BCryptHash.createSalt(this.random);
            }
            return new SimpleByteSource(saltBytes);
        }
    }

    public static final class Parameters {
        public static final String DEFAULT_ALGORITHM_NAME = "2y";
        public static final String PARAMETER_SALT = "BCrypt.salt";
        public static final String PARAMETER_COST = "BCrypt.cost";

        private Parameters() {
        }
    }
}

