/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DMLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OutputSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerUpdateStatement;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.impl.SQLServerStatementSQLVisitor;

public final class SQLServerDMLStatementSQLVisitor
extends SQLServerStatementSQLVisitor
implements DMLSQLVisitor,
SQLStatementVisitor {
    public SQLServerDMLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitInsert(SQLServerStatementParser.InsertContext ctx) {
        SQLServerInsertStatement result = null != ctx.insertDefaultValue() ? (SQLServerInsertStatement)this.visit((ParseTree)ctx.insertDefaultValue()) : (null != ctx.insertValuesClause() ? (SQLServerInsertStatement)this.visit((ParseTree)ctx.insertValuesClause()) : (SQLServerInsertStatement)this.visit((ParseTree)ctx.insertSelectClause()));
        if (null != ctx.withClause()) {
            result.setWithSegment((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitInsertDefaultValue(SQLServerStatementParser.InsertDefaultValueContext ctx) {
        SQLServerInsertStatement result = new SQLServerInsertStatement();
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        if (null != ctx.outputClause()) {
            result.setOutputSegment((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitOutputClause(SQLServerStatementParser.OutputClauseContext ctx) {
        OutputSegment result = new OutputSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.outputWithColumns()) {
            SQLServerStatementParser.OutputWithColumnsContext outputWithColumnsContext = ctx.outputWithColumns();
            List<SQLServerStatementParser.OutputWithColumnContext> outputWithColumnContexts = outputWithColumnsContext.outputWithColumn();
            LinkedList<ColumnProjectionSegment> outputColumns = new LinkedList<ColumnProjectionSegment>();
            for (SQLServerStatementParser.OutputWithColumnContext each : outputWithColumnContexts) {
                ColumnSegment column = new ColumnSegment(each.start.getStartIndex(), each.stop.getStopIndex(), new IdentifierValue(each.name().getText()));
                ColumnProjectionSegment outputColumn = new ColumnProjectionSegment(column);
                if (null != each.alias()) {
                    outputColumn.setAlias(new AliasSegment(each.alias().start.getStartIndex(), each.alias().stop.getStopIndex(), new IdentifierValue(each.name().getText())));
                }
                outputColumns.add(outputColumn);
            }
            result.getOutputColumns().addAll(outputColumns);
        }
        if (null != ctx.outputTableName()) {
            SQLServerStatementParser.OutputTableNameContext outputTableNameContext = ctx.outputTableName();
            TableNameSegment tableName = new TableNameSegment(outputTableNameContext.start.getStartIndex(), outputTableNameContext.stop.getStopIndex(), new IdentifierValue(outputTableNameContext.getText()));
            result.setTableName(tableName);
            if (null != ctx.columnNames()) {
                SQLServerStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
                CollectionValue columns = (CollectionValue)this.visit((ParseTree)columnNames);
                result.getTableColumns().addAll(columns.getValue());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitInsertValuesClause(SQLServerStatementParser.InsertValuesClauseContext ctx) {
        SQLServerInsertStatement result = new SQLServerInsertStatement();
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        if (null != ctx.outputClause()) {
            result.setOutputSegment((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<SQLServerStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (SQLServerStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertSelectClause(SQLServerStatementParser.InsertSelectClauseContext ctx) {
        SQLServerInsertStatement result = new SQLServerInsertStatement();
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        result.setInsertSelect(this.createInsertSelectSegment(ctx));
        if (null != ctx.outputClause()) {
            result.setOutputSegment((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        return result;
    }

    private InsertColumnsSegment createInsertColumns(SQLServerStatementParser.ColumnNamesContext columnNames, int startIndex) {
        if (null != columnNames) {
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            return new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue());
        }
        return new InsertColumnsSegment(startIndex - 1, startIndex - 1, Collections.emptyList());
    }

    private SubquerySegment createInsertSelectSegment(SQLServerStatementParser.InsertSelectClauseContext ctx) {
        SQLServerSelectStatement selectStatement = (SQLServerSelectStatement)this.visit((ParseTree)ctx.select());
        return new SubquerySegment(ctx.select().start.getStartIndex(), ctx.select().stop.getStopIndex(), (SelectStatement)selectStatement);
    }

    @Override
    public ASTNode visitWithClause(SQLServerStatementParser.WithClauseContext ctx) {
        List<SQLServerStatementParser.CteClauseContext> cteClauses = ctx.cteClause();
        LinkedList<CommonTableExpressionSegment> commonTableExpressions = new LinkedList<CommonTableExpressionSegment>();
        for (SQLServerStatementParser.CteClauseContext cte : cteClauses) {
            SubquerySegment subquery = new SubquerySegment(cte.subquery().start.getStartIndex(), cte.subquery().stop.getStopIndex(), (SelectStatement)((SQLServerSelectStatement)this.visit((ParseTree)cte.subquery())));
            IdentifierValue identifier = (IdentifierValue)this.visit((ParseTree)cte.identifier());
            CommonTableExpressionSegment commonTableExpression = new CommonTableExpressionSegment(cte.start.getStartIndex(), cte.stop.getStopIndex(), identifier, subquery);
            if (null != cte.columnNames()) {
                SQLServerStatementParser.ColumnNamesContext columnNames = cte.columnNames();
                CollectionValue columns = (CollectionValue)this.visit((ParseTree)columnNames);
                commonTableExpression.getColumns().addAll(columns.getValue());
            }
            commonTableExpressions.add(commonTableExpression);
        }
        return new WithSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), commonTableExpressions);
    }

    @Override
    public ASTNode visitUpdate(SQLServerStatementParser.UpdateContext ctx) {
        SQLServerUpdateStatement result = new SQLServerUpdateStatement();
        if (null != ctx.withClause()) {
            result.setWithSegment((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.tableReferences()));
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(SQLServerStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        for (SQLServerStatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(SQLServerStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (SQLServerStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(SQLServerStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
        result.getColumns().add(column);
        return result;
    }

    @Override
    public ASTNode visitAssignmentValue(SQLServerStatementParser.AssignmentValueContext ctx) {
        SQLServerStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDelete(SQLServerStatementParser.DeleteContext ctx) {
        SQLServerDeleteStatement result = new SQLServerDeleteStatement();
        if (null != ctx.withClause()) {
            result.setWithSegment((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.multipleTablesClause()) {
            result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.multipleTablesClause()));
        } else {
            result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        }
        if (null != ctx.outputClause()) {
            result.setOutputSegment((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(SQLServerStatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMultipleTablesClause(SQLServerStatementParser.MultipleTablesClauseContext ctx) {
        DeleteMultiTableSegment result = new DeleteMultiTableSegment();
        TableSegment relateTableSource = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setRelationTable(relateTableSource);
        result.setActualDeleteTables(this.generateTablesFromTableMultipleTableNames(ctx.multipleTableNames()));
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromTableMultipleTableNames(SQLServerStatementParser.MultipleTableNamesContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (SQLServerStatementParser.TableNameContext each : ctx.tableName()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitDuplicateSpecification(SQLServerStatementParser.DuplicateSpecificationContext ctx) {
        return new BooleanLiteralValue(null != ctx.DISTINCT());
    }

    @Override
    public ASTNode visitProjection(SQLServerStatementParser.ProjectionContext ctx) {
        AliasSegment alias;
        if (null != ctx.qualifiedShorthand()) {
            SQLServerStatementParser.QualifiedShorthandContext shorthand = ctx.qualifiedShorthand();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(shorthand.identifier().getText());
            result.setOwner(new OwnerSegment(shorthand.identifier().getStart().getStartIndex(), shorthand.identifier().getStop().getStopIndex(), identifier));
            return result;
        }
        AliasSegment aliasSegment = alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        if (null != ctx.top()) {
            RowNumberValueSegment rowNumber = (RowNumberValueSegment)this.visit((ParseTree)ctx.top());
            return new TopProjectionSegment(ctx.top().getStart().getStartIndex(), ctx.top().getStop().getStopIndex(), rowNumber, alias == null ? null : alias.getIdentifier().getValue());
        }
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            ColumnProjectionSegment result = new ColumnProjectionSegment(column);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias);
    }

    @Override
    public ASTNode visitTop(SQLServerStatementParser.TopContext ctx) {
        int startIndex = ctx.topNum().getStart().getStartIndex();
        int stopIndex = ctx.topNum().getStop().getStopIndex();
        ASTNode topNum = (ASTNode)this.visit((ParseTree)ctx.topNum());
        if (topNum instanceof NumberLiteralValue) {
            return new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, ((NumberLiteralValue)topNum).getValue().longValue(), false);
        }
        return new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerValue)topNum).getValue().intValue(), false);
    }

    @Override
    public ASTNode visitAlias(SQLServerStatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(SQLServerStatementParser.ProjectionContext ctx, AliasSegment alias) {
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)projection);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            int startIndex = ((BinaryOperationExpression)projection).getStartIndex();
            int stopIndex = null != alias ? alias.getStopIndex() : ((BinaryOperationExpression)projection).getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, ((BinaryOperationExpression)projection).getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment result = (ParameterMarkerExpressionSegment)projection;
            result.setAlias(alias);
            return projection;
        }
        LiteralExpressionSegment column = (LiteralExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getLiterals())) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getLiterals()));
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(SQLServerStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReference(SQLServerStatementParser.TableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        if (!ctx.joinedTable().isEmpty()) {
            for (SQLServerStatementParser.JoinedTableContext each : ctx.joinedTable()) {
                left = this.visitJoinedTable(each, left);
            }
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(SQLServerStatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            SQLServerSelectStatement subquery = (SQLServerSelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery);
            SubqueryTableSegment result = new SubqueryTableSegment(subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    private JoinTableSegment visitJoinedTable(SQLServerStatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        if (null != ctx.joinSpecification()) {
            result = this.visitJoinSpecification(ctx.joinSpecification(), result);
        }
        return result;
    }

    private JoinTableSegment visitJoinSpecification(SQLServerStatementParser.JoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            LinkedList<ColumnSegment> columnSegmentList = new LinkedList<ColumnSegment>();
            for (SQLServerStatementParser.ColumnNameContext cname : ctx.columnNames().columnName()) {
                columnSegmentList.add((ColumnSegment)this.visit((ParseTree)cname));
            }
            joinTableSource.setUsing(columnSegmentList);
        }
        return joinTableSource;
    }

    @Override
    public ASTNode visitSubquery(SQLServerStatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.aggregationClause());
    }

    @Generated
    public SQLServerDMLStatementSQLVisitor() {
    }
}

