/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.statement.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.segment.insert.InsertValueContext;
import org.apache.shardingsphere.sql.parser.relation.statement.impl.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;

public final class InsertSQLStatementContext
extends CommonSQLStatementContext {
    private final List<String> columnNames;
    private final List<InsertValueContext> insertValueContexts;

    public InsertSQLStatementContext(RelationMetas relationMetas, List<Object> parameters, InsertStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.columnNames = sqlStatement.useDefaultColumns() ? relationMetas.getAllColumnNames(this.getTablesContext().getSingleTableName()) : sqlStatement.getColumnNames();
        this.insertValueContexts = this.getInsertValueContexts(parameters);
    }

    private List<InsertValueContext> getInsertValueContexts(List<Object> parameters) {
        LinkedList<InsertValueContext> result = new LinkedList<InsertValueContext>();
        int parametersOffset = 0;
        for (Collection each : ((InsertStatement)this.getSqlStatement()).getAllValueExpressions()) {
            InsertValueContext insertValueContext = new InsertValueContext(each, parameters, parametersOffset);
            result.add(insertValueContext);
            parametersOffset += insertValueContext.getParametersCount();
        }
        return result;
    }

    public Iterator<String> getDescendingColumnNames() {
        return new LinkedList<String>(this.columnNames).descendingIterator();
    }

    public List<List<Object>> getGroupedParameters() {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (InsertValueContext each : this.insertValueContexts) {
            result.add(each.getParameters());
        }
        return result;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<InsertValueContext> getInsertValueContexts() {
        return this.insertValueContexts;
    }

    @Override
    public String toString() {
        return "InsertSQLStatementContext(super=" + super.toString() + ", columnNames=" + this.getColumnNames() + ", insertValueContexts=" + this.getInsertValueContexts() + ")";
    }
}

