/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl.OracleStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleAlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleRevokeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dcl.OracleSetRoleStatement;

public final class OracleDCLStatementSQLVisitor
extends OracleStatementSQLVisitor
implements DCLSQLVisitor,
SQLStatementVisitor {
    public OracleDCLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitGrant(OracleStatementParser.GrantContext ctx) {
        OracleGrantStatement result = new OracleGrantStatement();
        if (null != ctx.objectPrivilegeClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.objectPrivilegeClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(OracleStatementParser.RevokeContext ctx) {
        OracleRevokeStatement result = new OracleRevokeStatement();
        if (null != ctx.objectPrivilegeClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.objectPrivilegeClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(OracleStatementParser.ObjectPrivilegeClauseContext ctx) {
        return null == ctx.onObjectClause().tableName() ? Collections.emptyList() : Collections.singletonList((SimpleTableSegment)this.visit((ParseTree)ctx.onObjectClause().tableName()));
    }

    @Override
    public ASTNode visitCreateUser(OracleStatementParser.CreateUserContext ctx) {
        return new OracleCreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(OracleStatementParser.DropUserContext ctx) {
        return new OracleDropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(OracleStatementParser.AlterUserContext ctx) {
        return new OracleAlterUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(OracleStatementParser.CreateRoleContext ctx) {
        return new OracleCreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(OracleStatementParser.AlterRoleContext ctx) {
        return new OracleAlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(OracleStatementParser.DropRoleContext ctx) {
        return new OracleDropRoleStatement();
    }

    @Override
    public ASTNode visitSetRole(OracleStatementParser.SetRoleContext ctx) {
        return new OracleSetRoleStatement();
    }

    @Generated
    public OracleDCLStatementSQLVisitor() {
    }
}

