/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.ddl;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.ddl.MySQLColumnPositionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.ddl.column.ColumnDefinitionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnPositionSegment;

public final class MySQLChangeColumnDefinitionExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionExtractor = new ColumnDefinitionExtractor();

    public Optional<ModifyColumnDefinitionSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional changeColumnNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)ancestorNode, (RuleName)RuleName.CHANGE_COLUMN_SPECIFICATION);
        if (!changeColumnNode.isPresent()) {
            return Optional.absent();
        }
        Optional oldColumnNameNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)changeColumnNode.get()), (RuleName)RuleName.COLUMN_NAME);
        if (!oldColumnNameNode.isPresent()) {
            return Optional.absent();
        }
        Optional columnDefinitionNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)changeColumnNode.get()), (RuleName)RuleName.COLUMN_DEFINITION);
        if (!columnDefinitionNode.isPresent()) {
            return Optional.absent();
        }
        Optional columnDefinitionSegment = this.columnDefinitionExtractor.extract((ParserRuleContext)columnDefinitionNode.get(), parameterMarkerIndexes);
        if (columnDefinitionSegment.isPresent()) {
            ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(((ParserRuleContext)columnDefinitionNode.get()).getStart().getStartIndex(), ((ParserRuleContext)columnDefinitionNode.get()).getStop().getStopIndex(), (ColumnDefinitionSegment)columnDefinitionSegment.get());
            Optional<ColumnPositionSegment> columnPositionSegment = new MySQLColumnPositionExtractor(((ColumnDefinitionSegment)columnDefinitionSegment.get()).getColumnName()).extract((ParserRuleContext)changeColumnNode.get(), parameterMarkerIndexes);
            if (columnPositionSegment.isPresent()) {
                result.setColumnPosition((ColumnPositionSegment)columnPositionSegment.get());
            }
            return Optional.of((Object)result);
        }
        return Optional.absent();
    }
}

