/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.segment.dml.item;

import com.google.common.base.Optional;
import org.apache.shardingsphere.sql.parser.core.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public class AggregationSelectItemSegment
implements SelectItemSegment,
AliasAvailable {
    private final int startIndex;
    private final int stopIndex;
    private final String text;
    private final AggregationType type;
    private final int innerExpressionStartIndex;
    private String alias;

    public AggregationSelectItemSegment(int startIndex, int stopIndex, String text, AggregationType type, int innerExpressionStartIndex) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.text = SQLUtil.getExpressionWithoutOutsideParentheses(text);
        this.type = type;
        this.innerExpressionStartIndex = innerExpressionStartIndex;
    }

    @Override
    public final Optional<String> getAlias() {
        return Optional.fromNullable((Object)this.alias);
    }

    @Override
    public final void setAlias(String alias) {
        this.alias = SQLUtil.getExactlyValue(alias);
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public AggregationType getType() {
        return this.type;
    }

    public int getInnerExpressionStartIndex() {
        return this.innerExpressionStartIndex;
    }
}

