/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.segment.ddl.index;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.sql.parser.core.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class IndexSegment
implements SQLSegment {
    private final int startIndex;
    private final int stopIndex;
    private final String name;
    private final QuoteCharacter quoteCharacter;

    public IndexSegment(int startIndex, int stopIndex, String name) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.name = SQLUtil.getExactlyValue(name);
        this.quoteCharacter = QuoteCharacter.getQuoteCharacter(name);
    }

    @ConstructorProperties(value={"startIndex", "stopIndex", "name", "quoteCharacter"})
    public IndexSegment(int startIndex, int stopIndex, String name, QuoteCharacter quoteCharacter) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.name = name;
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public String getName() {
        return this.name;
    }

    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }
}

