/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.orderby;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.core.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class OrderByItemExtractor
implements CollectionSQLSegmentExtractor {
    private final OrderDirection nullOrderDirection;
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Collection<OrderByItemSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ORDER_BY_ITEM)) {
            OrderDirection orderDirection = 2 == each.getChildCount() && OrderDirection.DESC.name().equalsIgnoreCase(each.getChild(1).getText()) ? OrderDirection.DESC : OrderDirection.ASC;
            Optional<ParserRuleContext> indexNode = ExtractorUtils.findFirstChildNode(each, RuleName.NUMBER_LITERALS);
            if (indexNode.isPresent()) {
                result.add(new IndexOrderByItemSegment(((ParserRuleContext)indexNode.get()).getStart().getStartIndex(), ((ParserRuleContext)indexNode.get()).getStop().getStopIndex(), SQLUtil.getExactlyNumber(((ParserRuleContext)indexNode.get()).getText(), 10).intValue(), orderDirection, this.nullOrderDirection));
                continue;
            }
            Optional<ParserRuleContext> expressionNode = ExtractorUtils.findFirstChildNode(each, RuleName.EXPR);
            if (expressionNode.isPresent()) {
                result.add(new ExpressionOrderByItemSegment(((ParserRuleContext)expressionNode.get()).getStart().getStartIndex(), ((ParserRuleContext)expressionNode.get()).getStop().getStopIndex(), ((ParserRuleContext)expressionNode.get()).getText(), orderDirection, this.nullOrderDirection));
                continue;
            }
            Optional<ColumnSegment> columnSegment = this.columnExtractor.extract(each, parameterMarkerIndexes);
            if (!columnSegment.isPresent()) continue;
            result.add(new ColumnOrderByItemSegment(((ColumnSegment)columnSegment.get()).getStartIndex(), ((ColumnSegment)columnSegment.get()).getStopIndex(), (ColumnSegment)columnSegment.get(), orderDirection, this.nullOrderDirection));
        }
        return result;
    }

    @ConstructorProperties(value={"nullOrderDirection"})
    public OrderByItemExtractor(OrderDirection nullOrderDirection) {
        this.nullOrderDirection = nullOrderDirection;
    }
}

