/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.metadata.index;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.index.IndexMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.util.JdbcUtil;

public final class IndexMetaDataLoader {
    private static final String INDEX_NAME = "INDEX_NAME";

    public static Collection<IndexMetaData> load(Connection connection, String table, String databaseType) throws SQLException {
        HashSet<IndexMetaData> result = new HashSet<IndexMetaData>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), JdbcUtil.getSchema(connection, databaseType), table, false, false);){
            while (resultSet.next()) {
                String indexName = resultSet.getString(INDEX_NAME);
                if (null == indexName) continue;
                result.add(new IndexMetaData(indexName));
            }
        }
        return result;
    }

    @Generated
    private IndexMetaDataLoader() {
    }
}

