/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.metadata.column;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.util.JdbcUtil;

public final class ColumnMetaDataLoader {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";

    public static Collection<ColumnMetaData> load(Connection connection, String table, String databaseType) throws SQLException {
        if (!ColumnMetaDataLoader.isTableExist(connection, connection.getCatalog(), table, databaseType)) {
            return Collections.emptyList();
        }
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = ColumnMetaDataLoader.loadPrimaryKeys(connection, table, databaseType);
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        ArrayList<String> columnTypeNames = new ArrayList<String>();
        ArrayList<Boolean> isPrimaryKeys = new ArrayList<Boolean>();
        ArrayList<Boolean> isCaseSensitives = new ArrayList<Boolean>();
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), JdbcUtil.getSchema(connection, databaseType), table, "%");){
            while (resultSet.next()) {
                String columnName = resultSet.getString(COLUMN_NAME);
                columnTypes.add(resultSet.getInt(DATA_TYPE));
                columnTypeNames.add(resultSet.getString(TYPE_NAME));
                isPrimaryKeys.add(primaryKeys.contains(columnName));
                columnNames.add(columnName);
            }
        }
        resultSet = connection.createStatement().executeQuery(ColumnMetaDataLoader.generateEmptyResultSQL(table, databaseType));
        var11_12 = null;
        try {
            for (String each : columnNames) {
                isCaseSensitives.add(resultSet.getMetaData().isCaseSensitive(resultSet.findColumn(each)));
            }
        }
        catch (Throwable throwable) {
            var11_12 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (var11_12 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        var11_12.addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            result.add(new ColumnMetaData((String)columnNames.get(i), (Integer)columnTypes.get(i), (String)columnTypeNames.get(i), (Boolean)isPrimaryKeys.get(i), false, (Boolean)isCaseSensitives.get(i)));
        }
        return result;
    }

    private static String generateEmptyResultSQL(String table, String databaseType) {
        String delimiterRight;
        String delimiterLeft;
        if ("MySQL".equals(databaseType) || "MariaDB".equals(databaseType)) {
            delimiterLeft = "`";
            delimiterRight = "`";
        } else if ("Oracle".equals(databaseType) || "PostgreSQL".equals(databaseType) || "H2".equals(databaseType) || "SQL92".equals(databaseType)) {
            delimiterLeft = "\"";
            delimiterRight = "\"";
        } else if ("SQLServer".equals(databaseType)) {
            delimiterLeft = "[";
            delimiterRight = "]";
        } else {
            delimiterLeft = "";
            delimiterRight = "";
        }
        return "SELECT * FROM " + delimiterLeft + table + delimiterRight + " WHERE 1 != 1";
    }

    private static boolean isTableExist(Connection connection, String catalog, String table, String databaseType) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(catalog, JdbcUtil.getSchema(connection, databaseType), table, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private static Collection<String> loadPrimaryKeys(Connection connection, String table, String databaseType) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), JdbcUtil.getSchema(connection, databaseType), table);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    @Generated
    private ColumnMetaDataLoader() {
    }
}

