/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi.typed;

import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.spi.typed.TypedSPI;

public final class TypedSPIRegistry {
    public static <T extends TypedSPI> Optional<T> findRegisteredService(Class<T> typedSPIClass, String type, Properties props) {
        Optional<TypedSPI> serviceInstance = ShardingSphereServiceLoader.newServiceInstances(typedSPIClass).stream().filter(each -> each.getType().equalsIgnoreCase(type)).findFirst();
        if (!serviceInstance.isPresent()) {
            return Optional.empty();
        }
        TypedSPI result = serviceInstance.get();
        TypedSPIRegistry.setProperties(result, props);
        return Optional.of(result);
    }

    private static <T extends TypedSPI> void setProperties(T service, Properties props) {
        if (null == props) {
            return;
        }
        Properties newProps = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> newProps.setProperty(key.toString(), null == value ? null : value.toString())));
        service.setProps(newProps);
    }

    public static <T extends TypedSPI> T getRegisteredService(Class<T> typedSPIClass, String type, Properties props) {
        Optional<T> result = TypedSPIRegistry.findRegisteredService(typedSPIClass, type, props);
        if (result.isPresent()) {
            return (T)((TypedSPI)result.get());
        }
        throw new ServiceProviderNotFoundException(typedSPIClass, type);
    }

    @Generated
    private TypedSPIRegistry() {
    }
}

