/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SubqueryExtractUtils {
    public static Collection<SubquerySegment> getSubquerySegments(SelectStatement selectStatement) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        SubqueryExtractUtils.extractSubquerySegments(result, selectStatement);
        return result;
    }

    private static void extractSubquerySegments(List<SubquerySegment> result, SelectStatement selectStatement) {
        SubqueryExtractUtils.extractSubquerySegmentsFromProjections(result, selectStatement.getProjections());
        selectStatement.getFrom().ifPresent(optional -> SubqueryExtractUtils.extractSubquerySegmentsFromTableSegment(result, optional));
        if (selectStatement.getWhere().isPresent()) {
            SubqueryExtractUtils.extractSubquerySegmentsFromWhere(result, selectStatement.getWhere().get().getExpr());
        }
        if (selectStatement.getCombine().isPresent()) {
            SubqueryExtractUtils.extractSubquerySegmentsFromCombine(result, selectStatement.getCombine().get());
        }
    }

    private static void extractSubquerySegmentsFromProjections(List<SubquerySegment> result, ProjectionsSegment projections) {
        if (null == projections || projections.getProjections().isEmpty()) {
            return;
        }
        for (ProjectionSegment each : projections.getProjections()) {
            if (each instanceof SubqueryProjectionSegment) {
                SubquerySegment subquery = ((SubqueryProjectionSegment)each).getSubquery();
                subquery.setSubqueryType(SubqueryType.PROJECTION_SUBQUERY);
                result.add(subquery);
                SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
                continue;
            }
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((ExpressionProjectionSegment)each).getExpr(), SubqueryType.PROJECTION_SUBQUERY);
        }
    }

    private static void extractSubquerySegmentsFromTableSegment(List<SubquerySegment> result, TableSegment tableSegment) {
        if (tableSegment instanceof SubqueryTableSegment) {
            SubqueryExtractUtils.extractSubquerySegmentsFromSubqueryTableSegment(result, (SubqueryTableSegment)tableSegment);
        }
        if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getLeft());
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getRight());
        }
    }

    private static void extractSubquerySegmentsFromJoinTableSegment(List<SubquerySegment> result, TableSegment tableSegment) {
        if (tableSegment instanceof SubqueryTableSegment) {
            SubquerySegment subquery = ((SubqueryTableSegment)tableSegment).getSubquery();
            subquery.setSubqueryType(SubqueryType.JOIN_SUBQUERY);
            result.add(subquery);
            SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
        } else if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getLeft());
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getRight());
        }
    }

    private static void extractSubquerySegmentsFromSubqueryTableSegment(List<SubquerySegment> result, SubqueryTableSegment subqueryTableSegment) {
        SubquerySegment subquery = subqueryTableSegment.getSubquery();
        subquery.setSubqueryType(SubqueryType.TABLE_SUBQUERY);
        result.add(subquery);
        SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
    }

    private static void extractSubquerySegmentsFromWhere(List<SubquerySegment> result, ExpressionSegment expressionSegment) {
        SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, expressionSegment, SubqueryType.PREDICATE_SUBQUERY);
    }

    private static void extractSubquerySegmentsFromExpression(List<SubquerySegment> result, ExpressionSegment expressionSegment, SubqueryType subqueryType) {
        SubquerySegment subquery;
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            subquery = ((SubqueryExpressionSegment)expressionSegment).getSubquery();
            subquery.setSubqueryType(subqueryType);
            result.add(subquery);
            SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            subquery = ((ExistsSubqueryExpression)expressionSegment).getSubquery();
            subquery.setSubqueryType(subqueryType);
            result.add(subquery);
            SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
        }
        if (expressionSegment instanceof ListExpression) {
            for (ExpressionSegment each2 : ((ListExpression)expressionSegment).getItems()) {
                SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, each2, subqueryType);
            }
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getLeft(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getRight(), subqueryType);
        }
        if (expressionSegment instanceof InExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getLeft(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getRight(), subqueryType);
        }
        if (expressionSegment instanceof BetweenExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getBetweenExpr(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getAndExpr(), subqueryType);
        }
        if (expressionSegment instanceof NotExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((NotExpression)expressionSegment).getExpression(), subqueryType);
        }
        if (expressionSegment instanceof FunctionSegment) {
            ((FunctionSegment)expressionSegment).getParameters().forEach(each -> SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, each, subqueryType));
        }
    }

    private static void extractSubquerySegmentsFromCombine(List<SubquerySegment> result, CombineSegment combineSegment) {
        result.add(combineSegment.getLeft());
        result.add(combineSegment.getRight());
        SubqueryExtractUtils.extractSubquerySegments(result, combineSegment.getLeft().getSelect());
        SubqueryExtractUtils.extractSubquerySegments(result, combineSegment.getRight().getSelect());
    }

    @Generated
    private SubqueryExtractUtils() {
    }
}

