/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.enums.LogicalOperator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.TypeCastExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ValuesExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.IntervalExpressionProjection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.mysql.match.MatchAgainstExpression;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.join.OuterJoinExpression;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.multiset.MultisetExpression;

public final class ExpressionExtractUtils {
    public static Collection<AndPredicate> getAndPredicates(ExpressionSegment expression) {
        LinkedList<AndPredicate> result = new LinkedList<AndPredicate>();
        ExpressionExtractUtils.extractAndPredicates(result, expression);
        return result;
    }

    private static void extractAndPredicates(Collection<AndPredicate> result, ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            result.add(ExpressionExtractUtils.createAndPredicate(expression));
            return;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(binaryExpression.getOperator());
        if (logicalOperator.isPresent() && LogicalOperator.OR == logicalOperator.get()) {
            ExpressionExtractUtils.extractAndPredicates(result, binaryExpression.getLeft());
            ExpressionExtractUtils.extractAndPredicates(result, binaryExpression.getRight());
        } else if (logicalOperator.isPresent() && LogicalOperator.AND == logicalOperator.get()) {
            Collection<AndPredicate> predicates = ExpressionExtractUtils.getAndPredicates(binaryExpression.getRight());
            for (AndPredicate each : ExpressionExtractUtils.getAndPredicates(binaryExpression.getLeft())) {
                ExpressionExtractUtils.extractCombinedAndPredicates(result, each, predicates);
            }
        } else {
            result.add(ExpressionExtractUtils.createAndPredicate(expression));
        }
    }

    private static void extractCombinedAndPredicates(Collection<AndPredicate> result, AndPredicate current, Collection<AndPredicate> predicates) {
        for (AndPredicate each : predicates) {
            AndPredicate predicate = new AndPredicate();
            predicate.getPredicates().addAll(current.getPredicates());
            predicate.getPredicates().addAll(each.getPredicates());
            result.add(predicate);
        }
    }

    private static AndPredicate createAndPredicate(ExpressionSegment expression) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().add(expression);
        return result;
    }

    public static List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions(Collection<ExpressionSegment> expressions) {
        ArrayList<ParameterMarkerExpressionSegment> result = new ArrayList<ParameterMarkerExpressionSegment>();
        ExpressionExtractUtils.extractParameterMarkerExpressions(result, expressions);
        return result;
    }

    private static void extractParameterMarkerExpressions(List<ParameterMarkerExpressionSegment> result, Collection<ExpressionSegment> expressions) {
        for (ExpressionSegment each : expressions) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                result.add((ParameterMarkerExpressionSegment)each);
            }
            if (each instanceof BinaryOperationExpression) {
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, Collections.singleton(((BinaryOperationExpression)each).getLeft()));
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, Collections.singleton(((BinaryOperationExpression)each).getRight()));
            }
            if (each instanceof FunctionSegment) {
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, ((FunctionSegment)each).getParameters());
            }
            if (each instanceof TypeCastExpression) {
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, Collections.singleton(((TypeCastExpression)each).getExpression()));
            }
            if (!(each instanceof InExpression)) continue;
            ExpressionExtractUtils.extractParameterMarkerExpressions(result, ((InExpression)each).getExpressionList());
        }
    }

    public static void extractJoinConditions(Collection<BinaryOperationExpression> joinConditions, Collection<WhereSegment> whereSegments) {
        for (WhereSegment each : whereSegments) {
            if (!(each.getExpr() instanceof BinaryOperationExpression) || !(((BinaryOperationExpression)each.getExpr()).getLeft() instanceof ColumnSegment) || !(((BinaryOperationExpression)each.getExpr()).getRight() instanceof ColumnSegment)) continue;
            joinConditions.add((BinaryOperationExpression)each.getExpr());
        }
    }

    public static Collection<ColumnSegment> extractColumns(ExpressionSegment expression, boolean containsSubQuery) {
        if (expression instanceof ColumnSegment) {
            return Collections.singletonList((ColumnSegment)expression);
        }
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (expression instanceof AggregationProjectionSegment) {
            for (ExpressionSegment expressionSegment : ((AggregationProjectionSegment)expression).getParameters()) {
                result.addAll(ExpressionExtractUtils.extractColumns(expressionSegment, containsSubQuery));
            }
        }
        if (expression instanceof BetweenExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((BetweenExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((BetweenExpression)expression).getBetweenExpr(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((BetweenExpression)expression).getAndExpr(), containsSubQuery));
        }
        if (expression instanceof BinaryOperationExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((BinaryOperationExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((BinaryOperationExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof CaseWhenExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((CaseWhenExpression)expression).getCaseExpr(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((CaseWhenExpression)expression).getElseExpr(), containsSubQuery));
            ((CaseWhenExpression)expression).getWhenExprs().forEach(each -> result.addAll(ExpressionExtractUtils.extractColumns(each, containsSubQuery)));
            ((CaseWhenExpression)expression).getThenExprs().forEach(each -> result.addAll(ExpressionExtractUtils.extractColumns(each, containsSubQuery)));
        }
        if (expression instanceof OuterJoinExpression) {
            result.add(((OuterJoinExpression)expression).getColumnName());
        }
        if (expression instanceof CommonTableExpressionSegment) {
            result.addAll(((CommonTableExpressionSegment)expression).getColumns());
        }
        if (expression instanceof DatetimeExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((DatetimeExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((DatetimeExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof ExpressionProjectionSegment) {
            result.addAll(ExpressionExtractUtils.extractColumns(((ExpressionProjectionSegment)expression).getExpr(), containsSubQuery));
        }
        if (expression instanceof FunctionSegment) {
            for (ExpressionSegment expressionSegment : ((FunctionSegment)expression).getParameters()) {
                result.addAll(ExpressionExtractUtils.extractColumns(expressionSegment, containsSubQuery));
            }
        }
        if (expression instanceof InExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((InExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((InExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof IntervalExpressionProjection) {
            result.addAll(ExpressionExtractUtils.extractColumns(((IntervalExpressionProjection)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((IntervalExpressionProjection)expression).getRight(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((IntervalExpressionProjection)expression).getMinus(), containsSubQuery));
        }
        if (expression instanceof ListExpression) {
            for (ExpressionSegment expressionSegment : ((ListExpression)expression).getItems()) {
                result.addAll(ExpressionExtractUtils.extractColumns(expressionSegment, containsSubQuery));
            }
        }
        if (expression instanceof MatchAgainstExpression) {
            result.add(((MatchAgainstExpression)expression).getColumnName());
            result.addAll(ExpressionExtractUtils.extractColumns(((MatchAgainstExpression)expression).getExpr(), containsSubQuery));
        }
        if (expression instanceof MultisetExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((MultisetExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractUtils.extractColumns(((MultisetExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof NotExpression) {
            result.addAll(ExpressionExtractUtils.extractColumns(((NotExpression)expression).getExpression(), containsSubQuery));
        }
        if (expression instanceof ValuesExpression) {
            for (InsertValuesSegment insertValuesSegment : ((ValuesExpression)expression).getRowConstructorList()) {
                insertValuesSegment.getValues().forEach(value -> result.addAll(ExpressionExtractUtils.extractColumns(value, containsSubQuery)));
            }
        }
        if (expression instanceof SubquerySegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(result, ((SubquerySegment)expression).getSelect(), true);
        }
        if (expression instanceof SubqueryExpressionSegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(result, ((SubqueryExpressionSegment)expression).getSubquery().getSelect(), true);
        }
        return result;
    }

    @Generated
    private ExpressionExtractUtils() {
    }
}

