/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.type;

import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.OpenGaussStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussAnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussEmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussLoadStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussResetParameterStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussSetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussShowStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dal.OpenGaussVacuumStatement;

public final class OpenGaussDALStatementVisitor
extends OpenGaussStatementVisitor
implements DALStatementVisitor {
    @Override
    public ASTNode visitShow(OpenGaussStatementParser.ShowContext ctx) {
        if (null != ctx.varName()) {
            return new OpenGaussShowStatement(ctx.varName().getText());
        }
        if (null != ctx.ZONE()) {
            return new OpenGaussShowStatement("timezone");
        }
        if (null != ctx.ISOLATION()) {
            return new OpenGaussShowStatement("transaction_isolation");
        }
        if (null != ctx.AUTHORIZATION()) {
            return new OpenGaussShowStatement("session_authorization");
        }
        return new OpenGaussShowStatement("ALL");
    }

    @Override
    public ASTNode visitSet(OpenGaussStatementParser.SetContext ctx) {
        OpenGaussSetStatement result = new OpenGaussSetStatement();
        LinkedList<VariableAssignSegment> variableAssigns = new LinkedList<VariableAssignSegment>();
        if (null != ctx.configurationParameterClause()) {
            VariableAssignSegment variableAssignSegment = (VariableAssignSegment)this.visit((ParseTree)ctx.configurationParameterClause());
            if (null != ctx.runtimeScope()) {
                variableAssignSegment.getVariable().setScope(ctx.runtimeScope().getText());
            }
            variableAssigns.add(variableAssignSegment);
            result.getVariableAssigns().addAll(variableAssigns);
        }
        return result;
    }

    @Override
    public ASTNode visitConfigurationParameterClause(OpenGaussStatementParser.ConfigurationParameterClauseContext ctx) {
        VariableAssignSegment result = new VariableAssignSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setVariable(new VariableSegment(ctx.varName().start.getStartIndex(), ctx.varName().stop.getStopIndex(), ctx.varName().getText()));
        if (null != ctx.varList()) {
            result.setAssignValue(ctx.varList().getText());
        }
        if (null != ctx.DEFAULT()) {
            result.setAssignValue(ctx.DEFAULT().getText());
        }
        return result;
    }

    @Override
    public ASTNode visitResetParameter(OpenGaussStatementParser.ResetParameterContext ctx) {
        return new OpenGaussResetParameterStatement(null != ctx.ALL() ? "ALL" : ctx.identifier().getText());
    }

    @Override
    public ASTNode visitAnalyzeTable(OpenGaussStatementParser.AnalyzeTableContext ctx) {
        OpenGaussAnalyzeTableStatement result = new OpenGaussAnalyzeTableStatement();
        if (null != ctx.vacuumRelationList()) {
            result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.vacuumRelationList())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitVacuumRelationList(OpenGaussStatementParser.VacuumRelationListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.VacuumRelationContext each : ctx.vacuumRelation()) {
            OpenGaussStatementParser.ColIdContext colId = each.qualifiedName().colId();
            TableNameSegment tableName = new TableNameSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            result.getValue().add(new SimpleTableSegment(tableName));
        }
        return result;
    }

    @Override
    public ASTNode visitLoad(OpenGaussStatementParser.LoadContext ctx) {
        return new OpenGaussLoadStatement();
    }

    @Override
    public ASTNode visitVacuum(OpenGaussStatementParser.VacuumContext ctx) {
        return new OpenGaussVacuumStatement();
    }

    @Override
    public ASTNode visitExplain(OpenGaussStatementParser.ExplainContext ctx) {
        OpenGaussExplainStatement result = new OpenGaussExplainStatement();
        result.setStatement((SQLStatement)this.visit((ParseTree)ctx.explainableStmt()));
        return result;
    }

    @Override
    public ASTNode visitExplainableStmt(OpenGaussStatementParser.ExplainableStmtContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.update()) {
            return (ASTNode)this.visit((ParseTree)ctx.update());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.declare()) {
            return (ASTNode)this.visit((ParseTree)ctx.declare());
        }
        if (null != ctx.executeStmt()) {
            return (ASTNode)this.visit((ParseTree)ctx.executeStmt());
        }
        if (null != ctx.createMaterializedView()) {
            return (ASTNode)this.visit((ParseTree)ctx.createMaterializedView());
        }
        return (ASTNode)this.visit((ParseTree)ctx.refreshMatViewStmt());
    }

    @Override
    public ASTNode visitEmptyStatement(OpenGaussStatementParser.EmptyStatementContext ctx) {
        return new OpenGaussEmptyStatement();
    }
}

