/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class DatabaseMetaDataNodePath {
    private static final String ROOT_NODE = "/metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";
    private static final String VERSIONS_NODE = "versions";
    private static final String ACTIVE_VERSION_NODE = "active_version";
    private static final String IDENTIFIER_PATTERN = "([\\w\\-]+)";

    public static String getRootPath() {
        return ROOT_NODE;
    }

    public static String getDatabasePath(String databaseName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNodePath.getRootPath(), databaseName);
    }

    public static String getSchemaRootPath(String databaseName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNodePath.getDatabasePath(databaseName), SCHEMAS_NODE);
    }

    public static String getSchemaPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNodePath.getSchemaRootPath(databaseName), schemaName);
    }

    public static String getTableRootPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNodePath.getSchemaPath(databaseName, schemaName), TABLES_NODE);
    }

    public static String getVersionPath(String rulePath, String activeVersion) {
        return rulePath.replace(ACTIVE_VERSION_NODE, VERSIONS_NODE) + "/" + activeVersion;
    }

    public static Optional<String> findDatabaseName(String path, boolean containsChildPath) {
        String endPattern = containsChildPath ? "?" : "$";
        Pattern pattern = Pattern.compile(DatabaseMetaDataNodePath.getDatabasePath(IDENTIFIER_PATTERN) + endPattern, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> findSchemaName(String path, boolean containsChildPath) {
        String endPattern = containsChildPath ? "?" : "$";
        Pattern pattern = Pattern.compile(DatabaseMetaDataNodePath.getSchemaPath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN) + endPattern, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    @Generated
    private DatabaseMetaDataNodePath() {
    }
}

