/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.path.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.mode.path.rule.item.NamedRuleItemNodePath;
import org.apache.shardingsphere.mode.path.rule.item.UniqueRuleItemNodePath;
import org.apache.shardingsphere.mode.path.rule.root.RuleRootNodePath;

public final class RuleNodePath {
    private final RuleRootNodePath root;
    private final Map<String, NamedRuleItemNodePath> namedItems;
    private final Map<String, UniqueRuleItemNodePath> uniqueItems;

    public RuleNodePath(String ruleType, Collection<String> namedRuleItemNodePathTypes, Collection<String> uniqueRuleItemNodePathTypes) {
        this.root = new RuleRootNodePath(ruleType);
        this.namedItems = this.getNamedRuleItemNodePathMap(namedRuleItemNodePathTypes);
        this.uniqueItems = this.getUniqueRuleItemNodePathMap(uniqueRuleItemNodePathTypes);
    }

    private Map<String, NamedRuleItemNodePath> getNamedRuleItemNodePathMap(Collection<String> namedRuleItemNodePathTypes) {
        HashMap<String, NamedRuleItemNodePath> result = new HashMap<String, NamedRuleItemNodePath>(namedRuleItemNodePathTypes.size(), 1.0f);
        for (String each : namedRuleItemNodePathTypes) {
            result.put(each, new NamedRuleItemNodePath(this.root, each));
        }
        return result;
    }

    private Map<String, UniqueRuleItemNodePath> getUniqueRuleItemNodePathMap(Collection<String> uniqueRuleItemNodePathTypes) {
        HashMap<String, UniqueRuleItemNodePath> result = new HashMap<String, UniqueRuleItemNodePath>(uniqueRuleItemNodePathTypes.size(), 1.0f);
        for (String each : uniqueRuleItemNodePathTypes) {
            if (each.contains(".")) {
                String[] values = each.split("\\.");
                result.put(values[1], new UniqueRuleItemNodePath(this.root, values[0], values[1]));
                continue;
            }
            result.put(each, new UniqueRuleItemNodePath(this.root, each));
        }
        return result;
    }

    public NamedRuleItemNodePath getNamedItem(String itemType) {
        return this.namedItems.get(itemType);
    }

    public UniqueRuleItemNodePath getUniqueItem(String itemType) {
        return this.uniqueItems.get(itemType);
    }

    @Generated
    public RuleRootNodePath getRoot() {
        return this.root;
    }

    @Generated
    public Map<String, NamedRuleItemNodePath> getNamedItems() {
        return this.namedItems;
    }

    @Generated
    public Map<String, UniqueRuleItemNodePath> getUniqueItems() {
        return this.uniqueItems;
    }
}

