/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.merge.impl;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.shardingsphere.underlying.execute.QueryResult;
import org.apache.shardingsphere.underlying.merge.MergedResult;

public abstract class StreamMergedResult
implements MergedResult {
    private QueryResult currentQueryResult;
    private boolean wasNull;

    protected final QueryResult getCurrentQueryResult() throws SQLException {
        if (null == this.currentQueryResult) {
            throw new SQLException("Current ResultSet is null, ResultSet perhaps end of next.");
        }
        return this.currentQueryResult;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Object result = this.getCurrentQueryResult().getValue(columnIndex, type);
        this.wasNull = this.getCurrentQueryResult().wasNull();
        return result;
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        Object result = this.getCurrentQueryResult().getCalendarValue(columnIndex, type, calendar);
        this.wasNull = this.getCurrentQueryResult().wasNull();
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        InputStream result = this.getCurrentQueryResult().getInputStream(columnIndex, type);
        this.wasNull = this.getCurrentQueryResult().wasNull();
        return result;
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }

    public void setCurrentQueryResult(QueryResult currentQueryResult) {
        this.currentQueryResult = currentQueryResult;
    }

    public void setWasNull(boolean wasNull) {
        this.wasNull = wasNull;
    }
}

