/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.sql.Statement;
import lombok.Generated;
import org.apache.shardingsphere.driver.exception.ConnectionClosedException;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractConnectionAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.DriverDatabaseConnectionManager;
import org.apache.shardingsphere.driver.jdbc.core.datasource.metadata.ShardingSphereDatabaseMetaData;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSpherePreparedStatement;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSphereStatement;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.transaction.api.TransactionType;

public final class ShardingSphereConnection
extends AbstractConnectionAdapter {
    private final ProcessEngine processEngine = new ProcessEngine();
    private final String databaseName;
    private final ContextManager contextManager;
    private final DriverDatabaseConnectionManager databaseConnectionManager;
    private final String processId;
    private boolean autoCommit = true;
    private int transactionIsolation = 1;
    private boolean readOnly;
    private volatile boolean closed;

    public ShardingSphereConnection(String databaseName, ContextManager contextManager) {
        this.databaseName = databaseName;
        this.contextManager = contextManager;
        this.databaseConnectionManager = new DriverDatabaseConnectionManager(databaseName, contextManager);
        this.processId = this.processEngine.connect(new Grantee("", ""), databaseName);
    }

    public boolean isHoldTransaction() {
        return this.databaseConnectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ShardingSphereDatabaseMetaData(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, columnNames);
    }

    @Override
    public Statement createStatement() {
        return new ShardingSphereStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingSphereStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingSphereStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.databaseConnectionManager.getRandomConnection().prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.databaseConnectionManager.getRandomConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.databaseConnectionManager.getRandomConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.databaseConnectionManager.getConnectionTransaction().isLocalTransaction()) {
            this.processLocalTransaction();
        } else {
            this.processDistributedTransaction();
        }
    }

    private void processLocalTransaction() throws SQLException {
        this.databaseConnectionManager.setAutoCommit(this.autoCommit);
        if (!this.autoCommit) {
            this.getConnectionContext().getTransactionContext().beginTransaction(String.valueOf(this.databaseConnectionManager.getConnectionTransaction().getTransactionType()));
        }
    }

    private void processDistributedTransaction() throws SQLException {
        switch (this.databaseConnectionManager.getConnectionTransaction().getDistributedTransactionOperationType(this.autoCommit)) {
            case BEGIN: {
                this.beginDistributedTransaction();
                break;
            }
            case COMMIT: {
                this.databaseConnectionManager.getConnectionTransaction().commit();
                break;
            }
        }
    }

    private void beginDistributedTransaction() throws SQLException {
        this.databaseConnectionManager.close();
        this.databaseConnectionManager.getConnectionTransaction().begin();
        this.getConnectionContext().getTransactionContext().beginTransaction(String.valueOf(this.databaseConnectionManager.getConnectionTransaction().getTransactionType()));
    }

    public void handleAutoCommit() throws SQLException {
        if (!this.autoCommit && !this.databaseConnectionManager.getConnectionTransaction().isInTransaction()) {
            if (TransactionType.isDistributedTransaction((TransactionType)this.databaseConnectionManager.getConnectionTransaction().getTransactionType())) {
                this.beginDistributedTransaction();
            } else {
                this.getConnectionContext().getTransactionContext().beginTransaction(String.valueOf(this.databaseConnectionManager.getConnectionTransaction().getTransactionType()));
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.databaseConnectionManager.commit();
        }
        finally {
            this.databaseConnectionManager.getConnectionTransaction().setRollbackOnly(false);
            this.getConnectionContext().close();
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.databaseConnectionManager.rollback();
        }
        finally {
            this.databaseConnectionManager.getConnectionTransaction().setRollbackOnly(false);
            this.getConnectionContext().close();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClose();
        this.databaseConnectionManager.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClose();
        if (!this.isHoldTransaction()) {
            throw new SQLFeatureNotSupportedException("Savepoint can only be used in transaction blocks.");
        }
        return this.databaseConnectionManager.setSavepoint(name);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClose();
        ShardingSpherePreconditions.checkState((boolean)this.isHoldTransaction(), () -> new SQLFeatureNotSupportedException("Savepoint can only be used in transaction blocks."));
        return this.databaseConnectionManager.setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClose();
        if (!this.isHoldTransaction()) {
            return;
        }
        this.databaseConnectionManager.releaseSavepoint(savepoint);
    }

    private void checkClose() throws SQLException {
        ShardingSpherePreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, () -> new ConnectionClosedException().toSQLException());
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.databaseConnectionManager.getTransactionIsolation().orElseGet(() -> this.transactionIsolation);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
        this.databaseConnectionManager.setTransactionIsolation(level);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.databaseConnectionManager.setReadOnly(readOnly);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.databaseConnectionManager.isValid(timeout);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.databaseConnectionManager.getRandomConnection().createArrayOf(typeName, elements);
    }

    @Override
    public String getSchema() {
        return this.databaseName;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.databaseConnectionManager.close();
        this.processEngine.disconnect(this.processId);
    }

    private ConnectionContext getConnectionContext() {
        return this.databaseConnectionManager.getConnectionContext();
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }

    @Generated
    public DriverDatabaseConnectionManager getDatabaseConnectionManager() {
        return this.databaseConnectionManager;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }
}

