/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.env.Environment;

public abstract class AbstractAlgorithmProvidedBeanRegistry<T extends ShardingSphereAlgorithm>
implements BeanDefinitionRegistryPostProcessor,
BeanPostProcessor {
    private static final String POINT = ".";
    private static final String PROPS = "props";
    private static final String PROPS_SUFFIX = ".props";
    private static final String TYPE_SUFFIX = ".type";
    private final Environment environment;
    private final Map<String, Properties> propsMap = new HashMap<String, Properties>();

    protected final void registerBean(String prefix, Class<T> algorithmClass, BeanDefinitionRegistry registry) {
        if (!PropertyUtil.containPropertyPrefix(this.environment, prefix)) {
            return;
        }
        Map parameterMap = PropertyUtil.handle(this.environment, prefix, Map.class);
        Collection algorithmNames = parameterMap.keySet().stream().map(key -> key.contains(POINT) ? key.substring(0, key.indexOf(POINT)) : key).collect(Collectors.toSet());
        Map<String, AlgorithmConfiguration> algorithmConfigs = this.createAlgorithmConfigurations(prefix, algorithmNames);
        ShardingSphereServiceLoader.register(algorithmClass);
        for (Map.Entry<String, AlgorithmConfiguration> entry : algorithmConfigs.entrySet()) {
            AlgorithmConfiguration algorithmConfig = entry.getValue();
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ShardingSphereAlgorithmFactory.createAlgorithm((AlgorithmConfiguration)algorithmConfig, algorithmClass).getClass());
            registry.registerBeanDefinition(entry.getKey(), (BeanDefinition)builder.getBeanDefinition());
            this.propsMap.put(entry.getKey(), algorithmConfig.getProps());
        }
    }

    private Map<String, AlgorithmConfiguration> createAlgorithmConfigurations(String prefix, Collection<String> algorithmNames) {
        LinkedHashMap<String, AlgorithmConfiguration> result = new LinkedHashMap<String, AlgorithmConfiguration>(algorithmNames.size(), 1.0f);
        for (String each : algorithmNames) {
            result.put(each, this.createAlgorithmConfiguration(prefix, each));
        }
        return result;
    }

    private AlgorithmConfiguration createAlgorithmConfiguration(String prefix, String algorithmName) {
        String type = this.environment.getProperty(String.join((CharSequence)"", prefix, algorithmName, TYPE_SUFFIX));
        Properties props = this.getProperties(prefix, algorithmName);
        return new AlgorithmConfiguration(type, props);
    }

    private Properties getProperties(String prefix, String algorithmName) {
        String propsPrefix = String.join((CharSequence)"", prefix, algorithmName, PROPS_SUFFIX);
        Properties result = new Properties();
        if (PropertyUtil.containPropertyPrefix(this.environment, propsPrefix)) {
            result.putAll((Map<?, ?>)PropertyUtil.handle(this.environment, propsPrefix, Map.class));
        }
        return this.convertToStringTypedProperties(result);
    }

    private Properties convertToStringTypedProperties(Properties props) {
        Properties result = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty(key.toString(), null == value ? null : value.toString())));
        return result;
    }

    public final void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof ShardingSphereAlgorithm && this.propsMap.containsKey(beanName)) {
            ((ShardingSphereAlgorithm)bean).init(this.propsMap.get(beanName));
        }
        return bean;
    }

    @Generated
    protected AbstractAlgorithmProvidedBeanRegistry(Environment environment) {
        this.environment = environment;
    }
}

