/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.query;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;

public final class QueryContext {
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final HintValueContext hintValueContext;
    private final ConnectionContext connectionContext;
    private final ShardingSphereMetaData metaData;
    private final String usedDatabaseName;
    private final boolean useCache;

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData) {
        this(sqlStatementContext, sql, params, hintValueContext, connectionContext, metaData, false);
    }

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData, boolean useCache) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = params;
        this.hintValueContext = hintValueContext;
        this.connectionContext = connectionContext;
        this.metaData = metaData;
        this.usedDatabaseName = this.findUsedDatabaseNameFromSQLStatement(sqlStatementContext, connectionContext);
        this.useCache = useCache;
    }

    private String findUsedDatabaseNameFromSQLStatement(SQLStatementContext sqlStatementContext, ConnectionContext connectionContext) {
        if (sqlStatementContext instanceof TableAvailable) {
            return ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().orElse(connectionContext.getCurrentDatabaseName().orElse(null));
        }
        return connectionContext.getCurrentDatabaseName().orElse(null);
    }

    public ShardingSphereDatabase getUsedDatabase() {
        ShardingSpherePreconditions.checkNotNull((Object)this.usedDatabaseName, NoDatabaseSelectedException::new);
        ShardingSpherePreconditions.checkState((boolean)this.metaData.containsDatabase(this.usedDatabaseName), () -> new UnknownDatabaseException(this.usedDatabaseName));
        return this.metaData.getDatabase(this.usedDatabaseName);
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public String getUsedDatabaseName() {
        return this.usedDatabaseName;
    }

    @Generated
    public boolean isUseCache() {
        return this.useCache;
    }
}

