/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection.transaction;

import java.util.Optional;
import lombok.Generated;

public final class TransactionConnectionContext
implements AutoCloseable {
    private volatile String transactionType;
    private volatile boolean inTransaction;
    private volatile long beginMills;
    private volatile boolean exceptionOccur;
    private volatile String readWriteSplitReplicaRoute;

    public void beginTransaction(String transactionType) {
        this.transactionType = transactionType;
        this.inTransaction = true;
    }

    public boolean isInDistributedTransaction() {
        return this.inTransaction && ("XA".equals(this.transactionType) || "BASE".equals(this.transactionType));
    }

    public Optional<String> getTransactionType() {
        return Optional.ofNullable(this.transactionType);
    }

    public Optional<String> getReadWriteSplitReplicaRoute() {
        return Optional.ofNullable(this.readWriteSplitReplicaRoute);
    }

    @Override
    public void close() {
        this.transactionType = null;
        this.inTransaction = false;
        this.beginMills = 0L;
        this.exceptionOccur = false;
        this.readWriteSplitReplicaRoute = null;
    }

    @Generated
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Generated
    public long getBeginMills() {
        return this.beginMills;
    }

    @Generated
    public boolean isExceptionOccur() {
        return this.exceptionOccur;
    }

    @Generated
    public void setBeginMills(long beginMills) {
        this.beginMills = beginMills;
    }

    @Generated
    public void setExceptionOccur(boolean exceptionOccur) {
        this.exceptionOccur = exceptionOccur;
    }

    @Generated
    public void setReadWriteSplitReplicaRoute(String readWriteSplitReplicaRoute) {
        this.readWriteSplitReplicaRoute = readWriteSplitReplicaRoute;
    }
}

