/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutorDecider;
import org.apache.shardingsphere.infra.route.engine.type.AllSQLRouteExecutor;
import org.apache.shardingsphere.infra.route.engine.type.PartialSQLRouteExecutor;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class SQLRouteEngine {
    private final Collection<ShardingSphereRule> rules;
    private final ConfigurationProperties props;

    public RouteContext route(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database) {
        SQLRouteExecutor executor = this.isNeedRouteAll(queryContext.getSqlStatementContext().getSqlStatement()) ? new AllSQLRouteExecutor() : new PartialSQLRouteExecutor(this.rules, this.props);
        return executor.route(queryContext, globalRuleMetaData, database);
    }

    private boolean isNeedRouteAll(SQLStatement sqlStatement) {
        for (SQLRouteExecutorDecider each : ShardingSphereServiceLoader.getServiceInstances(SQLRouteExecutorDecider.class)) {
            if (!each.isNeedRouteAll(sqlStatement)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public SQLRouteEngine(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.rules = rules;
        this.props = props;
    }
}

