/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.SQLRouterFactory;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class PartialSQLRouteExecutor
implements SQLRouteExecutor {
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRouter> routers;

    public PartialSQLRouteExecutor(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.props = props;
        this.routers = SQLRouterFactory.getInstances(rules);
    }

    @Override
    public RouteContext route(ConnectionContext connectionContext, QueryContext queryContext, ShardingSphereDatabase database) {
        RouteContext result = new RouteContext();
        for (Map.Entry<ShardingSphereRule, SQLRouter> entry : this.routers.entrySet()) {
            if (result.getRouteUnits().isEmpty()) {
                result = entry.getValue().createRouteContext(queryContext, database, entry.getKey(), this.props, connectionContext);
                continue;
            }
            entry.getValue().decorateRouteContext(result, queryContext, database, entry.getKey(), this.props, connectionContext);
        }
        if (result.getRouteUnits().isEmpty() && 1 == database.getResourceMetaData().getDataSources().size()) {
            String singleDataSourceName = (String)database.getResourceMetaData().getDataSources().keySet().iterator().next();
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(singleDataSourceName, singleDataSourceName), Collections.emptyList()));
        }
        return result;
    }
}

