/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.parameter.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;

public final class StandardParameterBuilder
implements ParameterBuilder {
    private final List<Object> originalParameters;
    private final Map<Integer, Collection<Object>> addedIndexAndParameters = new HashMap<Integer, Collection<Object>>();
    private final Map<Integer, Object> replacedIndexAndParameters = new LinkedHashMap<Integer, Object>();
    private int addedParameterCount;
    private int maxAddedParameterIndex;

    public void addAddedParameters(int index, Collection<Object> params) {
        this.addedParameterCount += params.size();
        this.maxAddedParameterIndex = Math.max(this.maxAddedParameterIndex, index);
        this.addedIndexAndParameters.put(index, params);
    }

    public void addReplacedParameters(int index, Object param) {
        this.replacedIndexAndParameters.put(index, param);
    }

    @Override
    public List<Object> getParameters() {
        if (this.addedIndexAndParameters.isEmpty() && this.replacedIndexAndParameters.isEmpty()) {
            return new ArrayList<Object>(this.originalParameters);
        }
        List<Object> replacedParams = this.getReplacedParameters();
        int maxParamIndex = this.getMaxParameterIndex();
        ArrayList<Object> result = new ArrayList<Object>(replacedParams.size() + this.addedParameterCount);
        for (int index = 0; index <= maxParamIndex; ++index) {
            if (replacedParams.size() > index) {
                result.add(replacedParams.get(index));
            }
            if (!this.addedIndexAndParameters.containsKey(index)) continue;
            result.addAll(this.addedIndexAndParameters.get(index));
        }
        return result;
    }

    private List<Object> getReplacedParameters() {
        if (this.replacedIndexAndParameters.isEmpty()) {
            return this.originalParameters;
        }
        ArrayList<Object> result = new ArrayList<Object>(this.originalParameters);
        for (Map.Entry<Integer, Object> entry : this.replacedIndexAndParameters.entrySet()) {
            result.set(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private int getMaxParameterIndex() {
        return this.addedIndexAndParameters.isEmpty() ? this.originalParameters.size() - 1 : Math.max(this.originalParameters.size() - 1, this.maxAddedParameterIndex);
    }

    @Generated
    public StandardParameterBuilder(List<Object> originalParameters) {
        this.originalParameters = originalParameters;
    }

    @Generated
    public Map<Integer, Collection<Object>> getAddedIndexAndParameters() {
        return this.addedIndexAndParameters;
    }
}

