/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.engine.GenericSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.RouteSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class SQLRewriteEntry {
    private final ShardingSphereDatabase database;
    private final RuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators;

    public SQLRewriteEntry(ShardingSphereDatabase database, RuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.database = database;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.decorators = OrderedSPILoader.getServices(SQLRewriteContextDecorator.class, (Collection)database.getRuleMetaData().getRules());
    }

    public SQLRewriteResult rewrite(QueryContext queryContext, RouteContext routeContext, ConnectionContext connectionContext) {
        SQLRewriteContext sqlRewriteContext = this.createSQLRewriteContext(queryContext, routeContext, connectionContext);
        SQLTranslatorRule rule = (SQLTranslatorRule)this.globalRuleMetaData.getSingleRule(SQLTranslatorRule.class);
        return routeContext.getRouteUnits().isEmpty() ? new GenericSQLRewriteEngine(rule, this.database, this.globalRuleMetaData).rewrite(sqlRewriteContext, queryContext) : new RouteSQLRewriteEngine(rule, this.database, this.globalRuleMetaData).rewrite(sqlRewriteContext, routeContext, queryContext);
    }

    private SQLRewriteContext createSQLRewriteContext(QueryContext queryContext, RouteContext routeContext, ConnectionContext connectionContext) {
        HintValueContext hintValueContext = queryContext.getHintValueContext();
        SQLRewriteContext result = new SQLRewriteContext(this.database, queryContext.getSqlStatementContext(), queryContext.getSql(), queryContext.getParameters(), connectionContext, hintValueContext);
        this.decorate(result, routeContext, hintValueContext);
        result.generateSQLTokens();
        return result;
    }

    private void decorate(SQLRewriteContext sqlRewriteContext, RouteContext routeContext, HintValueContext hintValueContext) {
        if (hintValueContext.isSkipSQLRewrite()) {
            return;
        }
        for (Map.Entry<ShardingSphereRule, SQLRewriteContextDecorator> entry : this.decorators.entrySet()) {
            entry.getValue().decorate(entry.getKey(), this.props, sqlRewriteContext, routeContext);
        }
    }
}

