/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.loader.AbstractJDBCRowsLoader;

public final class MySQLRowsLoader
extends AbstractJDBCRowsLoader {
    private static final String YEAR_DATA_TYPE = "YEAR";

    @Override
    protected Object getDate(ResultSet resultSet, int columnIndex) throws SQLException {
        if (MySQLRowsLoader.isYearDataType(resultSet.getMetaData().getColumnTypeName(columnIndex))) {
            Object result = resultSet.getObject(columnIndex);
            return resultSet.wasNull() ? null : result;
        }
        return resultSet.getDate(columnIndex);
    }

    private static boolean isYearDataType(String columnDataTypeName) {
        return YEAR_DATA_TYPE.equalsIgnoreCase(columnDataTypeName);
    }

    public String getType() {
        return "MySQL";
    }
}

