/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.model;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class ExecuteProcessContext {
    private final String executionID;
    private final String schemaName;
    private final String username;
    private final String hostname;
    private final String sql;
    private final Collection<ExecuteProcessUnit> unitStatuses;
    private final long startTimeMillis = System.currentTimeMillis();

    public ExecuteProcessContext(String sql, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessConstants constants) {
        this.executionID = executionGroupContext.getExecutionID();
        this.sql = sql;
        this.schemaName = executionGroupContext.getSchemaName();
        Grantee grantee = executionGroupContext.getGrantee();
        this.username = null != grantee ? grantee.getUsername() : null;
        this.hostname = null != grantee ? grantee.getHostname() : null;
        this.unitStatuses = this.createExecutionUnitStatuses(executionGroupContext, constants);
    }

    private Collection<ExecuteProcessUnit> createExecutionUnitStatuses(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessConstants constants) {
        LinkedList<ExecuteProcessUnit> result = new LinkedList<ExecuteProcessUnit>();
        for (ExecutionGroup<? extends SQLExecutionUnit> group : executionGroupContext.getInputGroups()) {
            for (SQLExecutionUnit sQLExecutionUnit : group.getInputs()) {
                result.add(new ExecuteProcessUnit(sQLExecutionUnit.getExecutionUnit(), constants));
            }
        }
        return result;
    }

    @Generated
    public String getExecutionID() {
        return this.executionID;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public Collection<ExecuteProcessUnit> getUnitStatuses() {
        return this.unitStatuses;
    }

    @Generated
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }
}

