/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.sqlserver.connector;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.connector.StandardConnectionProperties;
import org.apache.shardingsphere.infra.database.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class SQLServerConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = 1433;
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:(microsoft:|tc:)?sqlserver:.*//([\\w\\-\\.]+):?(\\d*);\\S*(databaseName|database)=([\\w\\-\\.]+);?", 2);

    public ConnectionProperties parse(String url, String username, String catalog) {
        Matcher matcher = URL_PATTERN.matcher(url);
        ShardingSpherePreconditions.checkState((boolean)matcher.find(), () -> new UnrecognizedDatabaseURLException(url, URL_PATTERN.pattern()));
        return new StandardConnectionProperties(matcher.group(2), Strings.isNullOrEmpty((String)matcher.group(3)) ? 1433 : Integer.parseInt(matcher.group(3)), matcher.group(5), null);
    }

    public String getDatabaseType() {
        return "SQLServer";
    }
}

