/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresherFactory;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.mapper.SQLStatementEventMapper;
import org.apache.shardingsphere.infra.metadata.mapper.SQLStatementEventMapperFactory;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.refresher.FederationMetaDataRefresher;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class MetaDataRefreshEngine {
    private final ShardingSphereMetaData schemaMetaData;
    private final FederationSchemaMetaData federationMetaData;
    private final SchemaBuilderMaterials materials;
    private final ConfigurationProperties props;

    public MetaDataRefreshEngine(ShardingSphereMetaData schemaMetaData, FederationSchemaMetaData federationMetaData, ConfigurationProperties props) {
        this.schemaMetaData = schemaMetaData;
        this.federationMetaData = federationMetaData;
        this.props = props;
        this.materials = new SchemaBuilderMaterials(schemaMetaData.getResource().getDatabaseType(), schemaMetaData.getResource().getDataSources(), schemaMetaData.getRuleMetaData().getRules(), props);
    }

    public void refresh(SQLStatement sqlStatement, Collection<String> logicDataSourceNames) throws SQLException {
        Optional sqlStatementEventMapper;
        Collection<MetaDataRefresher> metaDataRefreshers = MetaDataRefresherFactory.newInstance(sqlStatement);
        if (!metaDataRefreshers.isEmpty()) {
            this.refresh(sqlStatement, logicDataSourceNames, metaDataRefreshers);
        }
        if ((sqlStatementEventMapper = SQLStatementEventMapperFactory.newInstance((SQLStatement)sqlStatement)).isPresent()) {
            ShardingSphereEventBus.getInstance().post((Object)((SQLStatementEventMapper)sqlStatementEventMapper.get()).map(sqlStatement));
        }
    }

    private void refresh(SQLStatement sqlStatement, Collection<String> logicDataSourceNames, Collection<MetaDataRefresher> refreshers) throws SQLException {
        for (MetaDataRefresher each : refreshers) {
            if (each instanceof SchemaRefresher) {
                ((SchemaRefresher)each).refresh(this.schemaMetaData, logicDataSourceNames, sqlStatement, this.materials.getProps());
            }
            if (!(each instanceof FederationMetaDataRefresher)) continue;
            ((FederationMetaDataRefresher)each).refresh(this.federationMetaData, logicDataSourceNames, sqlStatement, this.materials);
        }
        ShardingSphereEventBus.getInstance().post((Object)new SchemaAlteredEvent(this.schemaMetaData.getName(), this.loadActualSchema(this.schemaMetaData)));
    }

    private ShardingSphereSchema loadActualSchema(ShardingSphereMetaData schemaMetaData) throws SQLException {
        Map<String, Map> dataSourcesMap = Collections.singletonMap(schemaMetaData.getName(), schemaMetaData.getResource().getDataSources());
        Map<String, Collection> schemaRuleConfigs = Collections.singletonMap(schemaMetaData.getName(), schemaMetaData.getRuleMetaData().getConfigurations());
        Map rules = SchemaRulesBuilder.buildRules(dataSourcesMap, schemaRuleConfigs, (Properties)this.props.getProps());
        Map schemas = new SchemaLoader(dataSourcesMap, schemaRuleConfigs, rules, this.props.getProps()).load();
        return (ShardingSphereSchema)schemas.get(schemaMetaData.getName());
    }
}

