/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.schema.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereColumn;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereConstraint;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereIndex;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlColumnSwapper;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlConstraintSwapper;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlIndexSwapper;

public final class YamlTableSwapper
implements YamlConfigurationSwapper<YamlShardingSphereTable, ShardingSphereTable> {
    private final YamlColumnSwapper columnSwapper = new YamlColumnSwapper();
    private final YamlIndexSwapper indexSwapper = new YamlIndexSwapper();
    private final YamlConstraintSwapper constraintSwapper = new YamlConstraintSwapper();

    public YamlShardingSphereTable swapToYamlConfiguration(ShardingSphereTable table) {
        YamlShardingSphereTable result = new YamlShardingSphereTable();
        result.setName(table.getName());
        result.setColumns(this.swapToYamlColumns(table.getAllColumns()));
        result.setIndexes(this.swapToYamlIndexes(table.getAllIndexes()));
        result.setConstraints(this.swapToYamlConstraints(table.getAllConstraints()));
        result.setType(table.getType());
        return result;
    }

    private Map<String, YamlShardingSphereColumn> swapToYamlColumns(Collection<ShardingSphereColumn> columns) {
        return columns.stream().collect(Collectors.toMap(key -> key.getName().toLowerCase(), this.columnSwapper::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, YamlShardingSphereIndex> swapToYamlIndexes(Collection<ShardingSphereIndex> indexes) {
        return indexes.stream().collect(Collectors.toMap(key -> key.getName().toLowerCase(), this.indexSwapper::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, YamlShardingSphereConstraint> swapToYamlConstraints(Collection<ShardingSphereConstraint> constrains) {
        return constrains.stream().collect(Collectors.toMap(key -> key.getName().toLowerCase(), this.constraintSwapper::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public ShardingSphereTable swapToObject(YamlShardingSphereTable yamlConfig) {
        return new ShardingSphereTable(yamlConfig.getName(), this.swapToColumns(yamlConfig.getColumns()), this.swapToIndexes(yamlConfig.getIndexes()), this.swapToConstraints(yamlConfig.getConstraints()), yamlConfig.getType());
    }

    private Collection<ShardingSphereColumn> swapToColumns(Map<String, YamlShardingSphereColumn> columns) {
        return null == columns ? Collections.emptyList() : (Collection)columns.values().stream().map(this.columnSwapper::swapToObject).collect(Collectors.toList());
    }

    private Collection<ShardingSphereIndex> swapToIndexes(Map<String, YamlShardingSphereIndex> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this.indexSwapper::swapToObject).collect(Collectors.toList());
    }

    private Collection<ShardingSphereConstraint> swapToConstraints(Map<String, YamlShardingSphereConstraint> constraints) {
        return null == constraints ? Collections.emptyList() : (Collection)constraints.values().stream().map(this.constraintSwapper::swapToObject).collect(Collectors.toList());
    }
}

