/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.state.instance;

import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.shardingsphere.infra.state.instance.InstanceState;

public final class InstanceStateContext {
    private final Deque<InstanceState> currentState = new ConcurrentLinkedDeque<InstanceState>(Collections.singleton(InstanceState.OK));

    public void switchState(InstanceState state) {
        this.currentState.push(state);
    }

    public void recoverState(InstanceState state) {
        if (this.getCurrentState() == state) {
            this.recoverState();
        }
    }

    private void recoverState() {
        this.currentState.pop();
    }

    public InstanceState getCurrentState() {
        return Optional.ofNullable(this.currentState.peek()).orElse(InstanceState.OK);
    }
}

