/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.props;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.props.TypedPropertyKey;
import org.apache.shardingsphere.infra.props.TypedPropertyValue;
import org.apache.shardingsphere.infra.props.exception.TypedPropertiesServerException;
import org.apache.shardingsphere.infra.props.exception.TypedPropertyValueException;

public abstract class TypedProperties<E extends Enum<?>> {
    private final Properties props;
    private final Map<E, TypedPropertyValue> cache;

    protected TypedProperties(Class<E> keyClass, Properties props) {
        this.props = null == props ? new Properties() : props;
        this.cache = this.preload(keyClass);
    }

    private Map<E, TypedPropertyValue> preload(Class<E> keyClass) {
        Enum[] enumConstants = (Enum[])keyClass.getEnumConstants();
        HashMap<Enum, TypedPropertyValue> result = new HashMap<Enum, TypedPropertyValue>(enumConstants.length, 1.0f);
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Enum each : enumConstants) {
            TypedPropertyValue value = null;
            try {
                Object propsValue = this.props.getOrDefault((Object)((TypedPropertyKey)((Object)each)).getKey(), ((TypedPropertyKey)((Object)each)).getDefaultValue());
                value = new TypedPropertyValue((TypedPropertyKey)((Object)each), null == propsValue ? "" : propsValue.toString());
            }
            catch (TypedPropertyValueException ex) {
                errorMessages.add(ex.getMessage());
            }
            result.put(each, value);
        }
        if (!errorMessages.isEmpty()) {
            throw new TypedPropertiesServerException(errorMessages);
        }
        return result;
    }

    public final <T> T getValue(E key) {
        return (T)this.cache.get(key).getValue();
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

