/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.datanode.UnsupportedActualDataNodeStructureException;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;

public final class SchemaMetaDataUtils {
    public static Collection<MetaDataLoaderMaterial> getMetaDataLoaderMaterials(Collection<String> tableNames, GenericSchemaBuilderMaterial material) {
        LinkedHashMap<String, Collection<String>> dataSourceTableGroups = new LinkedHashMap<String, Collection<String>>();
        Collection<DatabaseType> unsupportedThreeTierStorageStructureDatabaseTypes = SchemaMetaDataUtils.getUnsupportedThreeTierStorageStructureDatabaseTypes(material.getStorageUnits().values());
        DataNodes dataNodes = new DataNodes(material.getRules());
        boolean checkMetaDataEnable = (Boolean)material.getProps().getValue(ConfigurationPropertyKey.CHECK_TABLE_METADATA_ENABLED);
        for (String each : tableNames) {
            SchemaMetaDataUtils.checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(unsupportedThreeTierStorageStructureDatabaseTypes, dataNodes, each);
            if (checkMetaDataEnable) {
                SchemaMetaDataUtils.addAllActualTableDataNode(material, dataSourceTableGroups, dataNodes, each);
                continue;
            }
            SchemaMetaDataUtils.addOneActualTableDataNode(material, dataSourceTableGroups, dataNodes, each);
        }
        LinkedList<MetaDataLoaderMaterial> result = new LinkedList<MetaDataLoaderMaterial>();
        int loadTableMetadataBatchSize = (Integer)material.getProps().getValue(ConfigurationPropertyKey.LOAD_TABLE_METADATA_BATCH_SIZE);
        for (Map.Entry entry : dataSourceTableGroups.entrySet()) {
            DatabaseType storageType = material.getStorageUnits().get(entry.getKey()).getStorageType();
            String defaultSchemaName = SchemaMetaDataUtils.getDefaultSchemaNameByStorageType(storageType, material.getDefaultSchemaName());
            result.addAll(SchemaMetaDataUtils.buildMaterials(material, (String)entry.getKey(), (Collection)entry.getValue(), storageType, defaultSchemaName, loadTableMetadataBatchSize));
        }
        return result;
    }

    private static Collection<MetaDataLoaderMaterial> buildMaterials(GenericSchemaBuilderMaterial material, String dataSourceName, Collection<String> actualTableNames, DatabaseType storageType, String defaultSchemaName, int loadTableMetadataBatchSize) {
        LinkedList<MetaDataLoaderMaterial> result = new LinkedList<MetaDataLoaderMaterial>();
        DataSource dataSource = SchemaMetaDataUtils.getDataSource(material, dataSourceName);
        for (List each : Lists.partition(new ArrayList<String>(actualTableNames), (int)loadTableMetadataBatchSize)) {
            result.add(new MetaDataLoaderMaterial((Collection)each, dataSourceName, dataSource, storageType, defaultSchemaName));
        }
        return result;
    }

    private static String getDefaultSchemaNameByStorageType(DatabaseType storageType, String databaseName) {
        return new DatabaseTypeRegistry(storageType).getDefaultSchemaName(databaseName);
    }

    private static DataSource getDataSource(GenericSchemaBuilderMaterial material, String dataSourceName) {
        return material.getStorageUnits().get(dataSourceName.contains(".") ? dataSourceName.split("\\.")[0] : dataSourceName).getDataSource();
    }

    private static void checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(Collection<DatabaseType> notSupportThreeTierStructureStorageTypes, DataNodes dataNodes, String tableName) {
        for (DataNode dataNode : dataNodes.getDataNodes(tableName)) {
            ShardingSpherePreconditions.checkState((notSupportThreeTierStructureStorageTypes.isEmpty() || !dataNode.getDataSourceName().contains(".") ? 1 : 0) != 0, () -> new UnsupportedActualDataNodeStructureException(dataNode.getDataSourceName(), dataNode.getTableName(), ((DatabaseType)notSupportThreeTierStructureStorageTypes.iterator().next()).getJdbcUrlPrefixes()));
            if (!dataNode.getDataSourceName().contains(".")) continue;
            String database = dataNode.getDataSourceName().split("\\.")[1];
            GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().put(dataNode.getTableName(), database);
        }
    }

    private static Collection<DatabaseType> getUnsupportedThreeTierStorageStructureDatabaseTypes(Collection<StorageUnit> storageUnits) {
        return storageUnits.stream().map(StorageUnit::getStorageType).filter(each -> !new DatabaseTypeRegistry(each).getDialectDatabaseMetaData().isSupportThreeTierStorageStructure()).collect(Collectors.toList());
    }

    private static void addOneActualTableDataNode(GenericSchemaBuilderMaterial material, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Optional<DataNode> dataNode = dataNodes.getDataNodes(table).stream().filter(each -> SchemaMetaDataUtils.isSameDataSourceNameSchemaName(material, each)).findFirst();
        if (!dataNode.isPresent() && !material.getStorageUnits().keySet().iterator().hasNext()) {
            return;
        }
        String dataSourceName = dataNode.map(DataNode::getDataSourceName).orElseGet(() -> material.getStorageUnits().keySet().iterator().next());
        String tableName = dataNode.map(DataNode::getTableName).orElse(table);
        SchemaMetaDataUtils.addDataSourceTableGroups(dataSourceName, tableName, dataSourceTableGroups);
    }

    private static boolean isSameDataSourceNameSchemaName(GenericSchemaBuilderMaterial material, DataNode dataNode) {
        String dataSourceName;
        String string = dataSourceName = dataNode.getDataSourceName().contains(".") ? dataNode.getDataSourceName().split("\\.")[0] : dataNode.getDataSourceName();
        if (!material.getStorageUnits().containsKey(dataSourceName)) {
            return false;
        }
        return null == dataNode.getSchemaName() || dataNode.getSchemaName().equalsIgnoreCase(material.getDefaultSchemaName());
    }

    private static void addAllActualTableDataNode(GenericSchemaBuilderMaterial material, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Collection<DataNode> tableDataNodes = dataNodes.getDataNodes(table);
        if (tableDataNodes.isEmpty() && !material.getStorageUnits().isEmpty()) {
            SchemaMetaDataUtils.addDataSourceTableGroups(material.getStorageUnits().keySet().iterator().next(), table, dataSourceTableGroups);
        } else {
            tableDataNodes.forEach(each -> SchemaMetaDataUtils.addDataSourceTableGroups(each.getDataSourceName(), each.getTableName(), dataSourceTableGroups));
        }
    }

    private static void addDataSourceTableGroups(String dataSourceName, String tableName, Map<String, Collection<String>> dataSourceTableGroups) {
        Collection tables = dataSourceTableGroups.getOrDefault(dataSourceName, new LinkedList());
        tables.add(tableName);
        dataSourceTableGroups.putIfAbsent(dataSourceName, tables);
    }

    @Generated
    private SchemaMetaDataUtils() {
    }
}

