/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeUtils;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;

public final class DataNodes {
    private final Collection<ShardingSphereRule> rules;

    public Collection<DataNode> getDataNodes(String tableName) {
        Collection<DataNode> result = this.getDataNodesByTableName(tableName);
        if (result.isEmpty()) {
            return result;
        }
        for (ShardingSphereRule each : this.getOrderedRules()) {
            Optional<DataSourceMapperRuleAttribute> dataSourceMapperRuleAttribute = each.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class);
            if (!dataSourceMapperRuleAttribute.isPresent()) continue;
            result = this.buildDataNodes(result, dataSourceMapperRuleAttribute.get());
        }
        return result;
    }

    private Collection<DataNode> getDataNodesByTableName(String tableName) {
        for (ShardingSphereRule each : this.rules) {
            Collection<DataNode> dataNodes = this.getDataNodesByTableName(each, tableName);
            if (dataNodes.isEmpty()) continue;
            return Collections.unmodifiableCollection(dataNodes);
        }
        return Collections.emptyList();
    }

    private Collection<DataNode> getDataNodesByTableName(ShardingSphereRule rule, String tableName) {
        return rule.getAttributes().findAttribute(DataNodeRuleAttribute.class).map(optional -> optional.getDataNodesByTableName(tableName)).orElse(Collections.emptyList());
    }

    private Collection<ShardingSphereRule> getOrderedRules() {
        ArrayList<ShardingSphereRule> result = new ArrayList<ShardingSphereRule>(this.rules);
        result.sort(Comparator.comparingInt(ShardingSphereRule::getOrder));
        return result;
    }

    private Collection<DataNode> buildDataNodes(Collection<DataNode> dataNodes, DataSourceMapperRuleAttribute dataSourceMapperRuleAttribute) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        Map<String, Collection<String>> dataSourceMapper = dataSourceMapperRuleAttribute.getDataSourceMapper();
        for (DataNode each : dataNodes) {
            result.addAll(DataNodeUtils.buildDataNode(each, dataSourceMapper));
        }
        return result;
    }

    @Generated
    public DataNodes(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
    }
}

