/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.adapter.MetaDataLoaderConnectionAdapter;

public final class SchemaTableNamesLoader {
    private static final String TABLE_TYPE = "TABLE";
    private static final String VIEW_TYPE = "VIEW";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEME = "TABLE_SCHEM";

    public static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType databaseType, DataSource dataSource) throws SQLException {
        try (MetaDataLoaderConnectionAdapter connectionAdapter = new MetaDataLoaderConnectionAdapter(databaseType, dataSource.getConnection());){
            Collection<String> schemaNames = SchemaTableNamesLoader.loadSchemaNames(connectionAdapter, databaseType);
            Map<String, Collection<String>> map = SchemaTableNamesLoader.loadSchemaTableNames(connectionAdapter, databaseName, databaseType, schemaNames);
            return map;
        }
    }

    private static Map<String, Collection<String>> loadSchemaTableNames(Connection connection, String databaseName, DatabaseType databaseType, Collection<String> schemaNames) throws SQLException {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(schemaNames.size(), 1.0f);
        for (String each : schemaNames) {
            String schemaName = databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType ? each : databaseName;
            result.put(schemaName, SchemaTableNamesLoader.loadSchemaTableNames(connection, each));
        }
        return result;
    }

    private static Collection<String> loadSchemaTableNames(Connection connection, String schemaName) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, null, new String[]{TABLE_TYPE, VIEW_TYPE});){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (SchemaTableNamesLoader.isSystemTable(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private static Collection<String> loadSchemaNames(Connection connection, DatabaseType databaseType) throws SQLException {
        if (!(databaseType instanceof PostgreSQLDatabaseType) && !(databaseType instanceof OpenGaussDatabaseType)) {
            return Collections.singletonList(connection.getSchema());
        }
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            while (resultSet.next()) {
                String schema = resultSet.getString(TABLE_SCHEME);
                if (databaseType.getSystemSchemas().contains(schema)) continue;
                result.add(schema);
            }
        }
        return result.isEmpty() ? Collections.singletonList(connection.getSchema()) : result;
    }

    private static boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/");
    }

    @Generated
    private SchemaTableNamesLoader() {
    }
}

