/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.props;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.InvalidDataSourcePropertiesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.exception.MismatchedProtocolAndDataSourceException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.internal.ShardingSphereInternalException;

public final class DataSourcePropertiesValidator {
    public void validate(Map<String, DataSourceProperties> dataSourcePropertiesMap, DatabaseType databaseType) throws InvalidResourcesException {
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropertiesMap.entrySet()) {
            try {
                this.validate(entry.getKey(), entry.getValue(), databaseType);
            }
            catch (InvalidDataSourcePropertiesException ex) {
                errorMessages.add(ex.getMessage());
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new InvalidResourcesException(errorMessages);
        }
    }

    private void validate(String dataSourceName, DataSourceProperties dataSourceProps, DatabaseType databaseType) throws InvalidDataSourcePropertiesException {
        DataSource dataSource = null;
        try {
            dataSource = DataSourcePoolCreator.create(dataSourceProps);
            this.checkFailFast(dataSource, databaseType);
        }
        catch (Exception ex) {
            throw new InvalidDataSourcePropertiesException(dataSourceName, ex.getMessage());
        }
        finally {
            if (null != dataSource) {
                new DataSourcePoolDestroyer(dataSource).asyncDestroy();
            }
        }
    }

    private void checkFailFast(DataSource dataSource, DatabaseType databaseType) throws SQLException, ShardingSphereInternalException {
        try (Connection connection = dataSource.getConnection();){
            ShardingSpherePreconditions.checkState((null == databaseType || DatabaseTypeEngine.getDatabaseType(connection.getMetaData().getURL()).getType().equals(databaseType.getType()) ? 1 : 0) != 0, MismatchedProtocolAndDataSourceException::new);
        }
    }
}

