/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.metadata;

import java.lang.reflect.Field;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolFieldMetaData;

public final class DataSourcePoolMetaDataReflection {
    private final DataSource targetDataSource;
    private final DataSourcePoolFieldMetaData dataSourcePoolFieldMetaData;

    public String getJdbcUrl() {
        return (String)this.getFieldValue(this.dataSourcePoolFieldMetaData.getJdbcUrlFieldName());
    }

    public String getUsername() {
        return (String)this.getFieldValue(this.dataSourcePoolFieldMetaData.getUsernameFieldName());
    }

    public String getPassword() {
        return (String)this.getFieldValue(this.dataSourcePoolFieldMetaData.getPasswordFieldName());
    }

    public Properties getJdbcConnectionProperties() {
        return (Properties)this.getFieldValue(this.dataSourcePoolFieldMetaData.getJdbcUrlPropertiesFieldName());
    }

    private <T> T getFieldValue(String fieldName) {
        Class<?> dataSourceClass = this.targetDataSource.getClass();
        Field field = null;
        boolean isFound = false;
        while (!isFound) {
            try {
                field = dataSourceClass.getDeclaredField(fieldName);
                isFound = true;
            }
            catch (ReflectiveOperationException ignored) {
                if (Object.class != (dataSourceClass = dataSourceClass.getSuperclass())) continue;
                return null;
            }
        }
        field.setAccessible(true);
        return (T)field.get(this.targetDataSource);
    }

    @Generated
    public DataSourcePoolMetaDataReflection(DataSource targetDataSource, DataSourcePoolFieldMetaData dataSourcePoolFieldMetaData) {
        this.targetDataSource = targetDataSource;
        this.dataSourcePoolFieldMetaData = dataSourcePoolFieldMetaData;
    }
}

