/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type.dialect;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.shardingsphere.infra.database.metadata.dialect.OpenGaussDataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.SchemaSupportedDatabaseType;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackStatement;

public final class OpenGaussDatabaseType
implements SchemaSupportedDatabaseType {
    private static final Map<String, Collection<String>> SYSTEM_DATABASE_SCHEMA_MAP = new HashMap<String, Collection<String>>();
    private static final Collection<String> SYSTEM_SCHEMAS = new HashSet<String>(Arrays.asList("information_schema", "pg_catalog", "blockchain", "cstore", "db4ai", "dbe_perf", "dbe_pldebugger", "gaussdb", "oracle", "pkg_service", "snapshot", "sqladvisor", "dbe_pldeveloper", "pg_toast", "pkg_util", "shardingsphere"));

    @Override
    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.QUOTE;
    }

    @Override
    public Collection<String> getJdbcUrlPrefixes() {
        return Collections.singleton(String.format("jdbc:%s:", this.getType().toLowerCase()));
    }

    @Override
    public OpenGaussDataSourceMetaData getDataSourceMetaData(String url, String username) {
        return new OpenGaussDataSourceMetaData(url);
    }

    @Override
    public void handleRollbackOnly(boolean rollbackOnly, SQLStatement statement) throws SQLException {
        ShardingSpherePreconditions.checkState((!rollbackOnly || statement instanceof CommitStatement || statement instanceof RollbackStatement ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("Current transaction is aborted, commands ignored until end of transaction block."));
    }

    @Override
    public Map<String, Collection<String>> getSystemDatabaseSchemaMap() {
        return SYSTEM_DATABASE_SCHEMA_MAP;
    }

    @Override
    public Collection<String> getSystemSchemas() {
        return SYSTEM_SCHEMAS;
    }

    @Override
    public boolean isSchemaAvailable() {
        return true;
    }

    @Override
    public String getDefaultSchema() {
        return "public";
    }

    public String getType() {
        return "openGauss";
    }

    static {
        SYSTEM_DATABASE_SCHEMA_MAP.put("postgres", SYSTEM_SCHEMAS);
    }
}

