/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public DropIndexStatementContext(DropIndexStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        SimpleTableSegment simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement).orElse(null);
        this.tablesContext = new TablesContext(simpleTableSegment, this.getDatabaseType());
    }

    public DropIndexStatement getSqlStatement() {
        return (DropIndexStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)this.getSqlStatement());
        return simpleTableSegment.map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        return this.getSqlStatement().getIndexes();
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        return Collections.emptyList();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

