/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.executor.hook;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.spi.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.underlying.executor.hook.SQLExecutionHook;

public final class SPISQLExecutionHook
implements SQLExecutionHook {
    private final Collection<SQLExecutionHook> sqlExecutionHooks = NewInstanceServiceLoader.newServiceInstances(SQLExecutionHook.class);

    @Override
    public void start(String dataSourceName, String sql, List<Object> parameters, DataSourceMetaData dataSourceMetaData, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) {
        for (SQLExecutionHook each : this.sqlExecutionHooks) {
            each.start(dataSourceName, sql, parameters, dataSourceMetaData, isTrunkThread, shardingExecuteDataMap);
        }
    }

    @Override
    public void finishSuccess() {
        for (SQLExecutionHook each : this.sqlExecutionHooks) {
            each.finishSuccess();
        }
    }

    @Override
    public void finishFailure(Exception cause) {
        for (SQLExecutionHook each : this.sqlExecutionHooks) {
            each.finishFailure(cause);
        }
    }

    static {
        NewInstanceServiceLoader.register(SQLExecutionHook.class);
    }
}

