/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.reg.zookeeper;

import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.shardingsphere.elasticjob.reg.base.ElectionCandidate;
import org.apache.shardingsphere.elasticjob.reg.exception.RegException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperElectionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperElectionService.class);
    private final CountDownLatch leaderLatch = new CountDownLatch(1);
    private final LeaderSelector leaderSelector;

    public ZookeeperElectionService(final String identity, CuratorFramework client, String electionPath, final ElectionCandidate electionCandidate) {
        this.leaderSelector = new LeaderSelector(client, electionPath, (LeaderSelectorListener)new LeaderSelectorListenerAdapter(){

            public void takeLeadership(CuratorFramework client) throws Exception {
                log.info("Elastic job: {} has leadership", (Object)identity);
                try {
                    electionCandidate.startLeadership();
                    ZookeeperElectionService.this.leaderLatch.await();
                    log.warn("Elastic job: {} lost leadership.", (Object)identity);
                    electionCandidate.stopLeadership();
                }
                catch (RegException exception) {
                    log.error("Elastic job: Starting error", (Throwable)exception);
                    System.exit(1);
                }
            }
        });
        this.leaderSelector.autoRequeue();
        this.leaderSelector.setId(identity);
    }

    public void start() {
        log.debug("Elastic job: {} start to elect leadership", (Object)this.leaderSelector.getId());
        this.leaderSelector.start();
    }

    public void stop() {
        log.info("Elastic job: stop leadership election");
        this.leaderLatch.countDown();
        try {
            this.leaderSelector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

