/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel.embadding;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactoryContext;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;
import org.apache.seatunnel.transform.nlpmodel.ModelProvider;
import org.apache.seatunnel.transform.nlpmodel.ModelTransformConfig;
import org.apache.seatunnel.transform.nlpmodel.embadding.EmbeddingTransform;
import org.apache.seatunnel.transform.nlpmodel.embadding.EmbeddingTransformConfig;
import org.apache.seatunnel.transform.nlpmodel.llm.LLMTransformConfig;

@AutoService(value={Factory.class})
public class EmbeddingTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "Embedding";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{EmbeddingTransformConfig.MODEL_PROVIDER, EmbeddingTransformConfig.MODEL, EmbeddingTransformConfig.VECTORIZATION_FIELDS}).optional(new Option[]{EmbeddingTransformConfig.API_PATH, EmbeddingTransformConfig.SINGLE_VECTORIZED_INPUT_NUMBER, EmbeddingTransformConfig.PROCESS_BATCH_SIZE}).conditional(EmbeddingTransformConfig.MODEL_PROVIDER, (List)Lists.newArrayList((Object[])new ModelProvider[]{ModelProvider.OPENAI, ModelProvider.DOUBAO}), new Option[]{EmbeddingTransformConfig.API_KEY}).conditional(EmbeddingTransformConfig.MODEL_PROVIDER, (Object)ModelProvider.QIANFAN, new Option[]{EmbeddingTransformConfig.API_KEY, EmbeddingTransformConfig.SECRET_KEY, EmbeddingTransformConfig.OAUTH_PATH}).conditional(LLMTransformConfig.MODEL_PROVIDER, (Object)ModelProvider.CUSTOM, new Option[]{ModelTransformConfig.CustomRequestConfig.CUSTOM_CONFIG}).build();
    }

    public TableTransform createTransform(TableTransformFactoryContext context) {
        return () -> new EmbeddingTransform(context.getOptions(), (CatalogTable)context.getCatalogTables().get(0));
    }
}

