/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.filter;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportTransform;
import org.apache.seatunnel.transform.exception.FilterFieldTransformErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.filter.FilterFieldTransformConfig;
import org.apache.seatunnel.transform.filter.FilterFieldTransformFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelTransform.class})
public class FilterFieldTransform
extends AbstractCatalogSupportTransform {
    private static final Logger log = LoggerFactory.getLogger(FilterFieldTransform.class);
    public static final String PLUGIN_NAME = "Filter";
    private int[] inputValueIndex;
    private String[] fields;

    public FilterFieldTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.fields = ((List)config.get(FilterFieldTransformConfig.KEY_FIELDS)).toArray(new String[0]);
        List canNotFoundFields = Arrays.stream(this.fields).filter(field -> seaTunnelRowType.indexOf(field) == -1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(canNotFoundFields)) {
            throw new TransformException((SeaTunnelErrorCode)FilterFieldTransformErrorCode.FILTER_FIELD_NOT_FOUND, canNotFoundFields.toString());
        }
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        ConfigValidator.of((ReadonlyConfig)ReadonlyConfig.fromConfig((Config)pluginConfig)).validate(new FilterFieldTransformFactory().optionRule());
        this.fields = ((List)ReadonlyConfig.fromConfig((Config)pluginConfig).get(FilterFieldTransformConfig.KEY_FIELDS)).toArray(new String[0]);
    }

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        int[] inputValueIndex = new int[this.fields.length];
        SeaTunnelDataType[] fieldDataTypes = new SeaTunnelDataType[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            String field = this.fields[i];
            int inputFieldIndex = inputRowType.indexOf(field);
            if (inputFieldIndex == -1) {
                throw new IllegalArgumentException("Cannot find [" + field + "] field in input row type");
            }
            fieldDataTypes[i] = inputRowType.getFieldType(inputFieldIndex);
            inputValueIndex[i] = inputFieldIndex;
        }
        SeaTunnelRowType outputRowType = new SeaTunnelRowType(this.fields, fieldDataTypes);
        log.info("Changed input row type: {} to output row type: {}", (Object)inputRowType, (Object)outputRowType);
        this.inputValueIndex = inputValueIndex;
        return outputRowType;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object[] values = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            values[i] = inputRow.getField(this.inputValueIndex[i]);
        }
        return new SeaTunnelRow(values);
    }

    @Override
    protected TableSchema transformTableSchema() {
        List<String> filterFields = Arrays.asList(this.fields);
        ArrayList<Column> outputColumns = new ArrayList<Column>();
        SeaTunnelRowType seaTunnelRowType = this.inputCatalogTable.getTableSchema().toPhysicalRowDataType();
        this.inputValueIndex = new int[filterFields.size()];
        for (int i = 0; i < filterFields.size(); ++i) {
            String field = filterFields.get(i);
            int inputFieldIndex = seaTunnelRowType.indexOf(field);
            if (inputFieldIndex == -1) {
                throw new IllegalArgumentException("Cannot find [" + field + "] field in input row type");
            }
            this.inputValueIndex[i] = inputFieldIndex;
            outputColumns.add(((Column)this.inputCatalogTable.getTableSchema().getColumns().get(inputFieldIndex)).copy());
        }
        List copyConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().map(ConstraintKey::copy).collect(Collectors.toList());
        PrimaryKey copiedPrimaryKey = this.inputCatalogTable.getTableSchema().getPrimaryKey() == null ? null : this.inputCatalogTable.getTableSchema().getPrimaryKey().copy();
        return TableSchema.builder().columns(outputColumns).primaryKey(copiedPrimaryKey).constraintKey(copyConstraintKeys).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }

    public FilterFieldTransform() {
    }
}

