/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.seatunnel.api.common.PluginIdentifierInterface;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.common.utils.ReflectionUtils;
import org.apache.seatunnel.plugin.discovery.PluginDiscovery;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginDiscovery<T>
implements PluginDiscovery<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginDiscovery.class);
    private static final String PLUGIN_MAPPING_FILE = "plugin-mapping.properties";
    private static final BiConsumer<ClassLoader, URL> DEFAULT_URL_TO_CLASSLOADER = (classLoader, url) -> {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new UnsupportedOperationException("can't support custom load jar");
        }
        ReflectionUtils.invoke((Object)classLoader, (String)"addURL", (Object[])new Object[]{url});
    };
    private final Path pluginDir;
    private final Config pluginMappingConfig;
    private final BiConsumer<ClassLoader, URL> addURLToClassLoaderConsumer;
    protected final ConcurrentHashMap<PluginIdentifier, Optional<URL>> pluginJarPath = new ConcurrentHashMap(16);

    public AbstractPluginDiscovery(BiConsumer<ClassLoader, URL> addURLToClassloader) {
        this(Common.connectorDir(), AbstractPluginDiscovery.loadConnectorPluginConfig(), addURLToClassloader);
    }

    public AbstractPluginDiscovery() {
        this(Common.connectorDir(), AbstractPluginDiscovery.loadConnectorPluginConfig());
    }

    public AbstractPluginDiscovery(Path pluginDir) {
        this(pluginDir, AbstractPluginDiscovery.loadConnectorPluginConfig());
    }

    public AbstractPluginDiscovery(Path pluginDir, Config pluginMappingConfig) {
        this(pluginDir, pluginMappingConfig, DEFAULT_URL_TO_CLASSLOADER);
    }

    public AbstractPluginDiscovery(Path pluginDir, Config pluginMappingConfig, BiConsumer<ClassLoader, URL> addURLToClassLoaderConsumer) {
        this.pluginDir = pluginDir;
        this.pluginMappingConfig = pluginMappingConfig;
        this.addURLToClassLoaderConsumer = addURLToClassLoaderConsumer;
        log.info("Load {} Plugin from {}", (Object)this.getPluginBaseClass().getSimpleName(), (Object)pluginDir);
    }

    protected static Config loadConnectorPluginConfig() {
        return ConfigFactory.parseFile((File)Common.connectorDir().resolve(PLUGIN_MAPPING_FILE).toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
    }

    @Override
    public List<URL> getPluginJarPaths(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::getPluginJarPath).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
    }

    @Override
    public List<T> getAllPlugins(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::createPluginInstance).distinct().collect(Collectors.toList());
    }

    public static Map<PluginIdentifier, String> getAllSupportedPlugins(PluginType pluginType) {
        Config config = AbstractPluginDiscovery.loadConnectorPluginConfig();
        HashMap<PluginIdentifier, String> pluginIdentifiers = new HashMap<PluginIdentifier, String>();
        if (config.isEmpty() || !config.hasPath("seatunnel")) {
            return pluginIdentifiers;
        }
        Config engineConfig = config.getConfig("seatunnel");
        if (engineConfig.hasPath(pluginType.getType())) {
            engineConfig.getConfig(pluginType.getType()).entrySet().forEach(entry -> pluginIdentifiers.put(PluginIdentifier.of("seatunnel", pluginType.getType(), (String)entry.getKey()), ((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        return pluginIdentifiers;
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier) {
        return this.createPluginInstance(pluginIdentifier, Collections.EMPTY_LIST);
    }

    @Override
    public Optional<T> createOptionalPluginInstance(PluginIdentifier pluginIdentifier) {
        return this.createOptionalPluginInstance(pluginIdentifier, Collections.EMPTY_LIST);
    }

    @Override
    public Optional<T> createOptionalPluginInstance(PluginIdentifier pluginIdentifier, Collection<URL> pluginJars) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        T pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader);
        if (pluginInstance != null) {
            log.info("Load plugin: {} from classpath", (Object)pluginIdentifier);
            return Optional.of(pluginInstance);
        }
        Optional<URL> pluginJarPath = this.getPluginJarPath(pluginIdentifier);
        if (pluginJarPath.isPresent()) {
            try {
                this.addURLToClassLoaderConsumer.accept(classLoader, pluginJarPath.get());
                for (URL jar : pluginJars) {
                    this.addURLToClassLoaderConsumer.accept(classLoader, jar);
                }
            }
            catch (Exception e) {
                log.warn("can't load jar use current thread classloader, use URLClassLoader instead now. message: " + e.getMessage());
                URL[] urls = new URL[pluginJars.size() + 1];
                int i = 0;
                for (URL pluginJar : pluginJars) {
                    urls[i++] = pluginJar;
                }
                urls[i] = pluginJarPath.get();
                classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            }
            if ((pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader)) != null) {
                log.info("Load plugin: {} from path: {} use classloader: {}", new Object[]{pluginIdentifier, pluginJarPath.get(), classLoader.getClass().getName()});
                return Optional.of(pluginInstance);
            }
        }
        return Optional.empty();
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier, Collection<URL> pluginJars) {
        Optional<T> instance = this.createOptionalPluginInstance(pluginIdentifier, pluginJars);
        if (instance.isPresent()) {
            return instance.get();
        }
        throw new RuntimeException("Plugin " + pluginIdentifier + " not found.");
    }

    @Override
    public ImmutableTriple<PluginIdentifier, List<Option<?>>, List<Option<?>>> getOptionRules(String pluginIdentifier) {
        Optional<Map.Entry> pluginEntry = this.getPlugins().entrySet().stream().filter(entry -> ((PluginIdentifier)entry.getKey()).getPluginName().equalsIgnoreCase(pluginIdentifier)).findFirst();
        if (pluginEntry.isPresent()) {
            Map.Entry entry2 = pluginEntry.get();
            List requiredOptions = ((OptionRule)entry2.getValue()).getRequiredOptions().stream().flatMap(requiredOption -> requiredOption.getOptions().stream()).collect(Collectors.toList());
            List optionalOptions = ((OptionRule)entry2.getValue()).getOptionalOptions();
            return ImmutableTriple.of((Object)((PluginIdentifier)entry2.getKey()), requiredOptions, (Object)optionalOptions);
        }
        return ImmutableTriple.of(null, new ArrayList(), new ArrayList());
    }

    protected void getPluginsByFactoryIdentifier(LinkedHashMap<PluginIdentifier, OptionRule> plugins, PluginType pluginType, String factoryIdentifier, OptionRule optionRule) {
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", pluginType.getType(), factoryIdentifier);
        plugins.computeIfAbsent(pluginIdentifier, k -> optionRule);
    }

    public Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> getAllPlugin() {
        List<Factory> factories = this.getPluginFactories();
        HashMap<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> plugins = new HashMap<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>>();
        factories.forEach(plugin -> {
            if (TableSourceFactory.class.isAssignableFrom(plugin.getClass())) {
                TableSourceFactory tableSourceFactory = (TableSourceFactory)plugin;
                plugins.computeIfAbsent(PluginType.SOURCE, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get(PluginType.SOURCE)).put(PluginIdentifier.of("seatunnel", PluginType.SOURCE.getType(), plugin.factoryIdentifier()), FactoryUtil.sourceFullOptionRule((TableSourceFactory)tableSourceFactory));
                return;
            }
            if (TableSinkFactory.class.isAssignableFrom(plugin.getClass())) {
                plugins.computeIfAbsent(PluginType.SINK, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get(PluginType.SINK)).put(PluginIdentifier.of("seatunnel", PluginType.SINK.getType(), plugin.factoryIdentifier()), FactoryUtil.sinkFullOptionRule((TableSinkFactory)((TableSinkFactory)plugin)));
                return;
            }
            if (TableTransformFactory.class.isAssignableFrom(plugin.getClass())) {
                plugins.computeIfAbsent(PluginType.TRANSFORM, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get(PluginType.TRANSFORM)).put(PluginIdentifier.of("seatunnel", PluginType.TRANSFORM.getType(), plugin.factoryIdentifier()), plugin.optionRule());
                return;
            }
        });
        return plugins;
    }

    protected List<Factory> getPluginFactories() {
        List factories;
        if (this.pluginDir.toFile().exists()) {
            List files;
            log.debug("load plugin from plugin dir: {}", (Object)this.pluginDir);
            try {
                files = FileUtils.searchJarFiles((Path)this.pluginDir);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can not find any plugin(source/sink/transform) in the dir: %s", this.pluginDir));
            }
            factories = FactoryUtil.discoverFactories((ClassLoader)new URLClassLoader(files.toArray(new URL[0])));
        } else {
            log.warn("plugin dir: {} not exists, load plugin from classpath", (Object)this.pluginDir);
            factories = FactoryUtil.discoverFactories((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        return factories;
    }

    protected T loadPluginInstance(PluginIdentifier pluginIdentifier, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(this.getPluginBaseClass(), classLoader);
        for (T t : serviceLoader) {
            if (t instanceof PluginIdentifierInterface) {
                PluginIdentifierInterface pluginIdentifierInstance = (PluginIdentifierInterface)t;
                if (!StringUtils.equalsIgnoreCase((CharSequence)pluginIdentifierInstance.getPluginName(), (CharSequence)pluginIdentifier.getPluginName())) continue;
                return (T)pluginIdentifierInstance;
            }
            throw new UnsupportedOperationException("Plugin instance: " + t + " is not supported.");
        }
        return null;
    }

    protected Optional<URL> getPluginJarPath(PluginIdentifier pluginIdentifier) {
        return this.pluginJarPath.computeIfAbsent(pluginIdentifier, this::findPluginJarPath);
    }

    protected abstract Class<T> getPluginBaseClass();

    private Optional<URL> findPluginJarPath(PluginIdentifier pluginIdentifier) {
        String engineType = pluginIdentifier.getEngineType().toLowerCase();
        String pluginType = pluginIdentifier.getPluginType().toLowerCase();
        String pluginName = pluginIdentifier.getPluginName().toLowerCase();
        if (!this.pluginMappingConfig.hasPath(engineType)) {
            return Optional.empty();
        }
        Config engineConfig = this.pluginMappingConfig.getConfig(engineType);
        if (!engineConfig.hasPath(pluginType)) {
            return Optional.empty();
        }
        Config typeConfig = engineConfig.getConfig(pluginType);
        Optional<Map.Entry> optional = typeConfig.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)pluginName)).findFirst();
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        final String pluginJarPrefix = ((ConfigValue)optional.get().getValue()).unwrapped().toString();
        Object[] targetPluginFiles = this.pluginDir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") && StringUtils.startsWithIgnoreCase((CharSequence)pathname.getName(), (CharSequence)pluginJarPrefix);
            }
        });
        if (ArrayUtils.isEmpty((Object[])targetPluginFiles)) {
            return Optional.empty();
        }
        try {
            URL pluginJarPath = targetPluginFiles.length == 1 ? ((File)targetPluginFiles[0]).toURI().toURL() : AbstractPluginDiscovery.findMostSimlarPluginJarFile((File[])targetPluginFiles, pluginJarPrefix).toURI().toURL();
            log.info("Discovery plugin jar for: {} at: {}", (Object)pluginIdentifier, (Object)pluginJarPath);
            return Optional.of(pluginJarPath);
        }
        catch (MalformedURLException e) {
            log.warn("Cannot get plugin URL: {} for pluginIdentifier: {}" + targetPluginFiles[0], (Object)pluginIdentifier, (Object)e);
            return Optional.empty();
        }
    }

    private static File findMostSimlarPluginJarFile(File[] targetPluginFiles, String pluginJarPrefix) {
        String splitRegex = "\\-|\\_|\\.";
        double maxSimlarity = -2.147483647E9;
        int mostSimlarPluginJarFileIndex = -1;
        for (int i = 0; i < targetPluginFiles.length; ++i) {
            File file = targetPluginFiles[i];
            String fileName = file.getName();
            double similarity = CosineSimilarityUtil.cosineSimilarity(pluginJarPrefix, fileName, splitRegex);
            if (!(similarity > maxSimlarity)) continue;
            maxSimlarity = similarity;
            mostSimlarPluginJarFileIndex = i;
        }
        return targetPluginFiles[mostSimlarPluginJarFileIndex];
    }

    static class CosineSimilarityUtil {
        CosineSimilarityUtil() {
        }

        public static double cosineSimilarity(String textA, String textB, String splitRegrex) {
            HashSet<String> words1 = new HashSet<String>(Arrays.asList(textA.toLowerCase().split(splitRegrex)));
            HashSet<String> words2 = new HashSet<String>(Arrays.asList(textB.toLowerCase().split(splitRegrex)));
            int[] termFrequency1 = CosineSimilarityUtil.calculateTermFrequencyVector(textA, words1, splitRegrex);
            int[] termFrequency2 = CosineSimilarityUtil.calculateTermFrequencyVector(textB, words2, splitRegrex);
            return CosineSimilarityUtil.calculateCosineSimilarity(termFrequency1, termFrequency2);
        }

        private static int[] calculateTermFrequencyVector(String text, Set<String> words, String splitRegrex) {
            int[] termFrequencyVector = new int[words.size()];
            String[] textArray = text.toLowerCase().split(splitRegrex);
            ArrayList<String> orderedWords = new ArrayList<String>();
            words.clear();
            for (String word : textArray) {
                if (words.contains(word)) continue;
                orderedWords.add(word);
                words.add(word);
            }
            block1: for (String word : textArray) {
                if (!words.contains(word)) continue;
                int index = 0;
                for (String w : orderedWords) {
                    if (w.equals(word)) {
                        int n = index;
                        termFrequencyVector[n] = termFrequencyVector[n] + 1;
                        continue block1;
                    }
                    ++index;
                }
            }
            return termFrequencyVector;
        }

        private static double calculateCosineSimilarity(int[] vectorA, int[] vectorB) {
            int i;
            int[] vectorTemp;
            double dotProduct = 0.0;
            double magnitudeA = 0.0;
            double magnitudeB = 0.0;
            int vectorALength = vectorA.length;
            int vectorBLength = vectorB.length;
            if (vectorALength < vectorBLength) {
                vectorTemp = new int[vectorBLength];
                for (i = 0; i < vectorB.length; ++i) {
                    vectorTemp[i] = i <= vectorALength - 1 ? vectorA[i] : 0;
                }
                vectorA = vectorTemp;
            }
            if (vectorALength > vectorBLength) {
                vectorTemp = new int[vectorALength];
                for (i = 0; i < vectorA.length; ++i) {
                    vectorTemp[i] = i <= vectorBLength - 1 ? vectorB[i] : 0;
                }
                vectorB = vectorTemp;
            }
            for (int i2 = 0; i2 < vectorA.length; ++i2) {
                dotProduct += (double)(vectorA[i2] * vectorB[i2]);
                magnitudeA += Math.pow(vectorA[i2], 2.0);
                magnitudeB += Math.pow(vectorB[i2], 2.0);
            }
            magnitudeA = Math.sqrt(magnitudeA);
            magnitudeB = Math.sqrt(magnitudeB);
            if (magnitudeA == 0.0 || magnitudeB == 0.0) {
                return 0.0;
            }
            return dotProduct / (magnitudeA * magnitudeB);
        }
    }
}

