/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ScheduledExecutorConfig
implements IdentifiedDataSerializable,
NamedConfig,
Versioned {
    private static final int DEFAULT_POOL_SIZE = 16;
    private static final int DEFAULT_CAPACITY = 100;
    private static final CapacityPolicy DEFAULT_CAPACITY_POLICY = CapacityPolicy.PER_NODE;
    private static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int durability = 1;
    private int capacity = 100;
    private CapacityPolicy capacityPolicy = DEFAULT_CAPACITY_POLICY;
    private int poolSize = 16;
    private String splitBrainProtectionName;
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();
    private boolean statisticsEnabled = true;

    public ScheduledExecutorConfig() {
    }

    public ScheduledExecutorConfig(String name) {
        this.name = name;
    }

    public ScheduledExecutorConfig(String name, int durability, int capacity, int poolSize, boolean statisticsEnabled) {
        this(name, durability, capacity, poolSize, null, new MergePolicyConfig(), DEFAULT_CAPACITY_POLICY, statisticsEnabled);
    }

    public ScheduledExecutorConfig(String name, int durability, int capacity, int poolSize, String splitBrainProtectionName, MergePolicyConfig mergePolicyConfig, CapacityPolicy capacityPolicy, boolean statisticsEnabled) {
        this.name = name;
        this.durability = durability;
        this.poolSize = poolSize;
        this.capacity = capacity;
        this.capacityPolicy = capacityPolicy;
        this.splitBrainProtectionName = splitBrainProtectionName;
        this.mergePolicyConfig = mergePolicyConfig;
        this.statisticsEnabled = statisticsEnabled;
    }

    public ScheduledExecutorConfig(ScheduledExecutorConfig config) {
        this(config.getName(), config.getDurability(), config.getCapacity(), config.getPoolSize(), config.getSplitBrainProtectionName(), new MergePolicyConfig(config.getMergePolicyConfig()), config.getCapacityPolicy(), config.isStatisticsEnabled());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ScheduledExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ScheduledExecutorConfig setPoolSize(int poolSize) {
        this.poolSize = Preconditions.checkPositive("poolSize", poolSize);
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public ScheduledExecutorConfig setDurability(int durability) {
        this.durability = Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        return this;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ScheduledExecutorConfig setCapacity(int capacity) {
        this.capacity = Preconditions.checkNotNegative(capacity, "capacity can't be smaller than 0");
        return this;
    }

    public CapacityPolicy getCapacityPolicy() {
        return this.capacityPolicy;
    }

    public ScheduledExecutorConfig setCapacityPolicy(@Nonnull CapacityPolicy capacityPolicy) {
        Preconditions.checkNotNull(capacityPolicy);
        this.capacityPolicy = capacityPolicy;
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public ScheduledExecutorConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public ScheduledExecutorConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null");
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ScheduledExecutorConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public String toString() {
        return "ScheduledExecutorConfig{name='" + this.name + '\'' + ", durability=" + this.durability + ", poolSize=" + this.poolSize + ", capacity=" + this.capacity + ", capacityPolicy=" + (Object)((Object)this.capacityPolicy) + ", statisticsEnabled=" + this.statisticsEnabled + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", mergePolicyConfig=" + this.mergePolicyConfig + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 32;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.durability);
        out.writeInt(this.capacity);
        out.writeInt(this.poolSize);
        out.writeString(this.splitBrainProtectionName);
        out.writeObject(this.mergePolicyConfig);
        out.writeByte(this.capacityPolicy.getId());
        out.writeBoolean(this.statisticsEnabled);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.durability = in.readInt();
        this.capacity = in.readInt();
        this.poolSize = in.readInt();
        this.splitBrainProtectionName = in.readString();
        this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
        this.capacityPolicy = CapacityPolicy.getById(in.readByte());
        this.statisticsEnabled = in.readBoolean();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledExecutorConfig)) {
            return false;
        }
        ScheduledExecutorConfig that = (ScheduledExecutorConfig)o;
        if (this.durability != that.durability) {
            return false;
        }
        if (this.capacity != that.capacity) {
            return false;
        }
        if (this.capacityPolicy != that.capacityPolicy) {
            return false;
        }
        if (this.poolSize != that.poolSize) {
            return false;
        }
        if (!Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName)) {
            return false;
        }
        if (!Objects.equals(this.mergePolicyConfig, that.mergePolicyConfig)) {
            return false;
        }
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.durability;
        result = 31 * result + this.capacity;
        result = 31 * result + this.capacityPolicy.hashCode();
        result = 31 * result + this.poolSize;
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        result = 31 * result + (this.mergePolicyConfig != null ? this.mergePolicyConfig.hashCode() : 0);
        return result;
    }

    public static enum CapacityPolicy {
        PER_NODE(0),
        PER_PARTITION(1);

        private final byte id;

        private CapacityPolicy(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static CapacityPolicy getById(byte id) {
            for (CapacityPolicy policy : CapacityPolicy.values()) {
                if (policy.id != id) continue;
                return policy;
            }
            return null;
        }
    }
}

