/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.exports;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.jmx.InstanceMBean;
import com.hazelcast.internal.jmx.PartitionServiceMBean;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.engine.server.telemetry.metrics.AbstractCollector;

public class NodeMetricExports
extends AbstractCollector {
    public NodeMetricExports(Node node) {
        super(node);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.nodeState(mfs);
        InstanceMBean instanceMBean = this.getManagementService().getInstanceMBean();
        if (instanceMBean == null) {
            return mfs;
        }
        String address = this.localAddress();
        List<String> labelNames = this.clusterLabelNames(ADDRESS, "type");
        GaugeMetricFamily isShutdownMetricFamily = new GaugeMetricFamily("hazelcast_executor_isShutdown", "The hazelcast executor isShutdown of seatunnel cluster node", labelNames);
        GaugeMetricFamily isTerminatedMetricFamily = new GaugeMetricFamily("hazelcast_executor_isTerminated", "The hazelcast executor isTerminated of seatunnel cluster node", labelNames);
        GaugeMetricFamily maxPoolSizeMetricFamily = new GaugeMetricFamily("hazelcast_executor_maxPoolSize", "The hazelcast executor maxPoolSize of seatunnel cluster node", labelNames);
        GaugeMetricFamily poolSizeMetricFamily = new GaugeMetricFamily("hazelcast_executor_poolSize", "The hazelcast executor poolSize of seatunnel cluster node", labelNames);
        GaugeMetricFamily queueRemainingCapacityMetricFamily = new GaugeMetricFamily("hazelcast_executor_queueRemainingCapacity", "The hazelcast executor queueRemainingCapacity of seatunnel cluster ", labelNames);
        GaugeMetricFamily queueSizeMetricFamily = new GaugeMetricFamily("hazelcast_executor_queueSize", "The hazelcast executor queueSize of seatunnel cluster node", labelNames);
        GaugeMetricFamily executedCountMetricFamily = new GaugeMetricFamily("hazelcast_executor_executedCount", "The hazelcast executor executedCount of seatunnel cluster node", labelNames);
        List<String> asyncValues = this.labelValues(address, "async");
        List<String> clientBlockingValues = this.labelValues(address, "clientBlocking");
        List<String> clientExecutorValues = this.labelValues(address, "client");
        List<String> clientQueryValues = this.labelValues(address, "clientQuery");
        List<String> ioValues = this.labelValues(address, "io");
        List<String> offloadableValues = this.labelValues(address, "offloadable");
        List<String> scheduledValues = this.labelValues(address, "scheduled");
        List<String> systemValues = this.labelValues(address, "system");
        this.longMetric(executedCountMetricFamily, instanceMBean.getAsyncExecutorMBean().getExecutedCount(), asyncValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getClientExecutorMBean().getExecutedCount(), clientExecutorValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getClientBlockingExecutorMBean().getExecutedCount(), clientBlockingValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getClientQueryExecutorMBean().getExecutedCount(), clientQueryValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getIoExecutorMBean().getExecutedCount(), ioValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getOffloadableExecutorMBean().getExecutedCount(), offloadableValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getScheduledExecutorMBean().getExecutedCount(), scheduledValues);
        this.longMetric(executedCountMetricFamily, instanceMBean.getSystemExecutorMBean().getExecutedCount(), systemValues);
        mfs.add((Collector.MetricFamilySamples)executedCountMetricFamily);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getAsyncExecutorMBean().isShutdown() ? 1 : 0, asyncValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getClientExecutorMBean().isShutdown() ? 1 : 0, clientExecutorValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getClientBlockingExecutorMBean().isShutdown() ? 1 : 0, clientBlockingValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getClientQueryExecutorMBean().isShutdown() ? 1 : 0, clientQueryValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getIoExecutorMBean().isShutdown() ? 1 : 0, ioValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getOffloadableExecutorMBean().isShutdown() ? 1 : 0, offloadableValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getScheduledExecutorMBean().isShutdown() ? 1 : 0, scheduledValues);
        this.intMetric(isShutdownMetricFamily, instanceMBean.getSystemExecutorMBean().isShutdown() ? 1 : 0, systemValues);
        mfs.add((Collector.MetricFamilySamples)isShutdownMetricFamily);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getAsyncExecutorMBean().isTerminated() ? 1 : 0, asyncValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getClientExecutorMBean().isTerminated() ? 1 : 0, clientExecutorValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getClientBlockingExecutorMBean().isTerminated() ? 1 : 0, clientBlockingValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getClientQueryExecutorMBean().isTerminated() ? 1 : 0, clientQueryValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getIoExecutorMBean().isTerminated() ? 1 : 0, ioValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getOffloadableExecutorMBean().isTerminated() ? 1 : 0, offloadableValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getScheduledExecutorMBean().isTerminated() ? 1 : 0, scheduledValues);
        this.intMetric(isTerminatedMetricFamily, instanceMBean.getSystemExecutorMBean().isTerminated() ? 1 : 0, systemValues);
        mfs.add((Collector.MetricFamilySamples)isTerminatedMetricFamily);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getAsyncExecutorMBean().maxPoolSize(), asyncValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getClientExecutorMBean().maxPoolSize(), clientExecutorValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getClientBlockingExecutorMBean().maxPoolSize(), clientBlockingValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getClientQueryExecutorMBean().maxPoolSize(), clientQueryValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getIoExecutorMBean().maxPoolSize(), ioValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getOffloadableExecutorMBean().maxPoolSize(), offloadableValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getScheduledExecutorMBean().maxPoolSize(), scheduledValues);
        this.intMetric(maxPoolSizeMetricFamily, instanceMBean.getSystemExecutorMBean().maxPoolSize(), systemValues);
        mfs.add((Collector.MetricFamilySamples)maxPoolSizeMetricFamily);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getAsyncExecutorMBean().poolSize(), asyncValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getClientExecutorMBean().poolSize(), clientExecutorValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getClientBlockingExecutorMBean().poolSize(), clientBlockingValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getClientQueryExecutorMBean().poolSize(), clientQueryValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getIoExecutorMBean().poolSize(), ioValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getOffloadableExecutorMBean().poolSize(), offloadableValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getScheduledExecutorMBean().poolSize(), scheduledValues);
        this.intMetric(poolSizeMetricFamily, instanceMBean.getSystemExecutorMBean().poolSize(), systemValues);
        mfs.add((Collector.MetricFamilySamples)poolSizeMetricFamily);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getAsyncExecutorMBean().queueRemainingCapacity(), asyncValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getClientExecutorMBean().queueRemainingCapacity(), clientExecutorValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getClientBlockingExecutorMBean().queueRemainingCapacity(), clientBlockingValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getClientQueryExecutorMBean().queueRemainingCapacity(), clientQueryValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getIoExecutorMBean().queueRemainingCapacity(), ioValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getOffloadableExecutorMBean().queueRemainingCapacity(), offloadableValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getScheduledExecutorMBean().queueRemainingCapacity(), scheduledValues);
        this.intMetric(queueRemainingCapacityMetricFamily, instanceMBean.getSystemExecutorMBean().queueRemainingCapacity(), systemValues);
        mfs.add((Collector.MetricFamilySamples)queueRemainingCapacityMetricFamily);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getAsyncExecutorMBean().queueSize(), asyncValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getClientExecutorMBean().queueSize(), clientExecutorValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getClientBlockingExecutorMBean().queueSize(), clientBlockingValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getClientQueryExecutorMBean().queueSize(), clientQueryValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getIoExecutorMBean().queueSize(), ioValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getOffloadableExecutorMBean().queueSize(), offloadableValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getScheduledExecutorMBean().queueSize(), scheduledValues);
        this.intMetric(queueSizeMetricFamily, instanceMBean.getSystemExecutorMBean().queueSize(), systemValues);
        mfs.add((Collector.MetricFamilySamples)queueSizeMetricFamily);
        this.partitionMetric(instanceMBean.getPartitionServiceMBean(), mfs, address);
        return mfs;
    }

    private void partitionMetric(PartitionServiceMBean partitionServiceMBean, List<Collector.MetricFamilySamples> mfs, String address) {
        List<String> labelNames = this.clusterLabelNames(ADDRESS);
        GaugeMetricFamily partitionPartitionCount = new GaugeMetricFamily("hazelcast_partition_partitionCount", "The partitionCount of seatunnel cluster node", labelNames);
        this.intMetric(partitionPartitionCount, partitionServiceMBean.getPartitionCount(), this.labelValues(address));
        mfs.add((Collector.MetricFamilySamples)partitionPartitionCount);
        GaugeMetricFamily partitionActivePartition = new GaugeMetricFamily("hazelcast_partition_activePartition", "The activePartition of seatunnel cluster node", labelNames);
        this.intMetric(partitionActivePartition, partitionServiceMBean.getActivePartitionCount(), this.labelValues(address));
        mfs.add((Collector.MetricFamilySamples)partitionActivePartition);
        GaugeMetricFamily partitionIsClusterSafe = new GaugeMetricFamily("hazelcast_partition_isClusterSafe", "Whether is cluster safe of partition", labelNames);
        this.intMetric(partitionIsClusterSafe, partitionServiceMBean.isClusterSafe() ? 1 : 0, this.labelValues(address));
        mfs.add((Collector.MetricFamilySamples)partitionIsClusterSafe);
        GaugeMetricFamily partitionIsLocalMemberSafe = new GaugeMetricFamily("hazelcast_partition_isLocalMemberSafe", "Whether is local member safe of partition", labelNames);
        this.intMetric(partitionIsLocalMemberSafe, partitionServiceMBean.isLocalMemberSafe() ? 1 : 0, this.labelValues(address));
        mfs.add((Collector.MetricFamilySamples)partitionIsLocalMemberSafe);
    }

    private void nodeState(List<Collector.MetricFamilySamples> mfs) {
        GaugeMetricFamily metricFamily = new GaugeMetricFamily("node_state", "Whether is up of seatunnel node ", this.clusterLabelNames(ADDRESS));
        String address = this.localAddress();
        List<String> labelValues = this.labelValues(address);
        metricFamily.addMetric(labelValues, 1.0);
        mfs.add((Collector.MetricFamilySamples)metricFamily);
    }
}

